/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;

/**
 * 大部分AppMsg都有一些公共的字段，用这个类来表示。
 * 
 * @title BaseAppMsg
 * @author yanmaoyuan
 * @date 2019年12月11日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class BaseAppMsg {

    private AppMsg appmsg;

    @JacksonXmlProperty(localName = "fromusername")
    private String fromUsername;

    private Integer scene;

    @JacksonXmlProperty(localName = "commenturl")
    private String commentUrl;

}