package com.kuaike.skynet.logic.wechat.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信可以引用的消息类型
 */
public enum ReferMsgType {
    TEXT(1, -1, "文本"),
    IMAGE(3, -1, "图片"),
    VIDEO(43, -1, "视频"),
    GIF(47, 1, "动图"),
    LOCATION(48, -1, "位置"),
    LINK(49, 5, "链接"),
    File(49, 6, "文件"),
    MINI_PROGRAM(49, 33, "小程序"),
    REFER(49, 57, "引用");

    private Integer referType;
    private Integer type;
    private String desc;

    ReferMsgType(Integer referType, Integer type, String desc) {
        this.referType = referType;
        this.type = type;
        this.desc = desc;
    }

    private final static Map<Integer, ReferMsgType> referCache;
    private final static Map<Integer, ReferMsgType> cache;

    static {
        referCache = new HashMap<>();
        cache = new HashMap<>();
        for (ReferMsgType e : values()) {
            referCache.put(e.referType, e);
            cache.put(e.type, e);
        }
    }

    public static ReferMsgType getByReferType(Integer type) {
        return referCache.get(type);
    }

    public static ReferMsgType getByType(Integer type) {
        return cache.get(type);
    }

    public String getDesc() {
        return this.desc;
    }

    public int getType() {
        return this.type;
    }
}
