/**
 * kuaike.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 微信小程序
 * 
 * @title WxMiniProgramMsg
 * @author yanmaoyuan
 * @date 2020年4月9日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class WxMiniProgramMsg {

    private MiniProgramAppMsg appmsg;

    @JacksonXmlProperty(localName = "fromusername")
    private String fromUsername;

    private Integer scene;

    @JacksonXmlProperty(localName = "commenturl")
    private String commentUrl;

    @Data
    @EqualsAndHashCode(callSuper = false)
    public static class MiniProgramAppMsg extends AppMsg {

        private String username;

        private String action;

        @JacksonXmlProperty(localName = "showtype")
        private Integer showType;

        private String content;

        @JacksonXmlProperty(localName = "lowurl")
        private String lowUrl;

        @JacksonXmlProperty(localName = "dataurl")
        private String dataUrl;

        @JacksonXmlProperty(localName = "lowdataurl")
        private String lowDataUrl;

        private String extinfo;

        @JacksonXmlProperty(localName = "androidsource")
        private Integer androidSource;

        @JacksonXmlProperty(localName = "sourceusername")
        private String sourceUsername;

        @JacksonXmlProperty(localName = "sourcedisplayname")
        private String sourceDisplayName;

        @JacksonXmlProperty(localName = "mediatagname")
        private String mediaTagName;

        private String md5;

        @JacksonXmlProperty(localName = "weappinfo")
        private WeappInfo weappInfo;
    }

    @Data
    public static class WeappInfo {
        @JacksonXmlProperty(localName = "pagepath")
        @JacksonXmlCData
        private String pagePath;

        private String username;

        private String appid;

        private Integer version;

        private Integer type;

        @JacksonXmlProperty(localName = "weappiconurl")
        @JacksonXmlCData
        private String weappIconUrl;

        @JacksonXmlCData
        private String shareId;

        @JacksonXmlProperty(localName = "appservicetype")
        private String appServiceType;

        @JacksonXmlProperty(localName = "videopageinfo")
        private VideoPageInfo videoPageInfo;
    }

    @Data
    public static class VideoPageInfo {
        @JacksonXmlProperty(localName = "thumbwidth")
        private Integer thumbWidth;

        @JacksonXmlProperty(localName = "thumbheight")
        private Integer thumbHeight;

        @JacksonXmlProperty(localName = "fromopensdk")
        private Integer fromOpenSdk;
    }

}