/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class WordTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_MATCH_TYPE = 1;
    public static final int MAX_MATCH_TYPE = 2;
    private boolean isEnd = false;
    private HashMap<Character, WordTree> next = new HashMap();

    public WordTree() {
    }

    public WordTree(Collection<String> words) {
        for (String word : words) {
            this.addWord(word);
        }
    }

    public void addWords(Collection<String> words) {
        for (String word : words) {
            this.addWord(word);
        }
    }

    public void addWord(String word) {
        if (word == null || word.isEmpty()) {
            return;
        }
        WordTree cur = this;
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char keyChar = word.charAt(i);
            WordTree next = cur.next.get(Character.valueOf(keyChar));
            if (next == null) {
                next = new WordTree();
                cur.next.put(Character.valueOf(keyChar), next);
            }
            cur = next;
            if (i != len - 1) continue;
            cur.isEnd = true;
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.next.isEmpty();
    }

    public int checkWord(String txt, int beginIndex, int matchType) {
        char word;
        boolean flag = false;
        WordTree cur = this;
        int length = txt.length();
        int curLength = 0;
        for (int i = beginIndex; i < length && (cur = cur.next.get(Character.valueOf(word = txt.charAt(i)))) != null; ++i) {
            ++curLength;
            if (!cur.isEnd) continue;
            flag = true;
            if (1 == matchType) break;
        }
        if (!flag) {
            curLength = 0;
        }
        return curLength;
    }

    public boolean isContaintWord(String txt) {
        if (txt == null || txt.isEmpty()) {
            return false;
        }
        if (this.next.isEmpty()) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < txt.length(); ++i) {
            int matchFlag = this.checkWord(txt, i, 1);
            if (matchFlag <= 0) continue;
            flag = true;
        }
        return flag;
    }

    public List<String> getMatchedWords(String txt) {
        LinkedHashSet<String> matched = new LinkedHashSet<String>();
        if (txt == null || txt.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.next.isEmpty()) {
            return Collections.emptyList();
        }
        int length = txt.length();
        for (int i = 0; i < length; ++i) {
            int beginIndex;
            char word;
            WordTree cur = this;
            int curLength = 0;
            for (int k = beginIndex = i; k < length && (cur = cur.next.get(Character.valueOf(word = txt.charAt(k)))) != null; ++k) {
                ++curLength;
                if (!cur.isEnd) continue;
                String curWord = txt.substring(beginIndex, beginIndex + curLength);
                matched.add(curWord);
            }
        }
        return Lists.newArrayList(matched);
    }

    public static final void main(String[] args) {
        HashSet<String> words = new HashSet<String>();
        words.add("\u7231\u56fd");
        words.add("\u548c\u8c10");
        words.add("\u5bcc\u5f3a");
        WordTree tree = new WordTree();
        tree.addWords(words);
        System.out.println(tree);
        System.out.println("\u654f\u611f\u8bcd\u7684\u6570\u91cf\uff1a" + tree.next.size());
        StringBuffer sb = new StringBuffer();
        sb.append("\u793e\u4f1a\u4e3b\u4e49\u6838\u5fc3\u4ef7\u503c\u89c2\u7684\u57fa\u672c\u5185\u5bb9\u662f\uff1a");
        sb.append("\u5bcc\u5f3a\u3001\u6c11\u4e3b\u3001\u6587\u660e\u3001\u548c\u8c10\u3001\u81ea\u7531\u3001\u5e73\u7b49\u3001\u516c\u6b63\u3001\u6cd5\u6cbb\u3001\u7231\u56fd\u3001\u656c\u4e1a\u3001\u8bda\u4fe1\u3001\u53cb\u5584\u3002");
        sb.append("\u201c\u5bcc\u5f3a\u3001\u6c11\u4e3b\u3001\u6587\u660e\u3001\u548c\u8c10\u201d\uff0c\u662f\u6211\u56fd\u793e\u4f1a\u4e3b\u4e49\u73b0\u4ee3\u5316\u56fd\u5bb6\u7684\u5efa\u8bbe\u76ee\u6807\uff1b");
        sb.append("\u201c\u81ea\u7531\u3001\u5e73\u7b49\u3001\u516c\u6b63\u3001\u6cd5\u6cbb\u201d\uff0c\u662f\u5bf9\u7f8e\u597d\u793e\u4f1a\u7684\u751f\u52a8\u8868\u8ff0\uff1b");
        sb.append("\u201c\u7231\u56fd\u3001\u656c\u4e1a\u3001\u8bda\u4fe1\u3001\u53cb\u5584\u201d\uff0c\u662f\u516c\u6c11\u57fa\u672c\u9053\u5fb7\u89c4\u8303\uff0c\u662f\u4ece\u4e2a\u4eba\u884c\u4e3a\u5c42\u9762\u5bf9\u793e\u4f1a\u4e3b\u4e49\u6838\u5fc3\u4ef7\u503c\u89c2\u57fa\u672c\u7406\u5ff5\u7684\u51dd\u7ec3\u3002");
        String string = sb.toString();
        System.out.println("\u5f85\u68c0\u6d4b\u8bed\u53e5\u5b57\u6570\uff1a" + string.length());
        List<String> set = null;
        long beginTime = System.currentTimeMillis();
        int n = 400000;
        for (int i = 0; i < n; ++i) {
            set = tree.getMatchedWords(string);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u8bed\u53e5\u4e2d\u5305\u542b\u654f\u611f\u8bcd\u7684\u4e2a\u6570\u4e3a\uff1a" + set.size() + "\u3002\u5305\u542b\uff1a" + set);
        System.out.println("\u5faa\u73af\u68c0\u6d4b" + n + "\u6b21\u603b\u5171\u6d88\u8017\u65f6\u95f4\u4e3a\uff1a" + (endTime - beginTime) + "ms");
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public HashMap<Character, WordTree> getNext() {
        return this.next;
    }

    public void setEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    public void setNext(HashMap<Character, WordTree> next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordTree)) {
            return false;
        }
        WordTree other = (WordTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnd() != other.isEnd()) {
            return false;
        }
        HashMap<Character, WordTree> this$next = this.getNext();
        HashMap<Character, WordTree> other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WordTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnd() ? 79 : 97);
        HashMap<Character, WordTree> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public String toString() {
        return "WordTree(isEnd=" + this.isEnd() + ", next=" + this.getNext() + ")";
    }
}

