/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 微信应用链接消息
 * 
 * 这个链接会用在多种场合，比如分享网址、邀请入群等。
 * 
 * @title WxAppUrlMsg
 * @author yanmaoyuan
 * @date 2019年12月19日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class WxAppUrlMsg {

    private AppUrlMsg appmsg;

    @Data
    @EqualsAndHashCode(callSuper = false)
    public static class AppUrlMsg extends AppMsg {

        private String action;

        @JacksonXmlProperty(localName = "showtype")
        private Integer showType;

        private String content;

        @JacksonXmlProperty(localName = "lowurl")
        private String lowUrl;

        @JacksonXmlProperty(localName = "dataurl")
        private String dataUrl;

        @JacksonXmlProperty(localName = "lowdataurl")
        private String lowDataUrl;

        private String extinfo;
    }
}