/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 微信红包消息
 * 
 * @title RedPackMsg
 * @author yanmaoyuan
 * @date 2019年12月10日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class RedPackMsg {

    private RedPackAppMsg appmsg;

    /**
     * 发送红包的wxid
     */
    @JacksonXmlProperty(localName = "fromusername")
    private String fromUsername;

    @Data
    @EqualsAndHashCode(callSuper = false)
    public static class RedPackAppMsg extends AppMsg {

        @JacksonXmlProperty(localName = "wcpayinfo")
        private WechatPayInfo wechatPayInfo;

        private Emoji emoji;
    }

    @Data
    public static class WechatPayInfo {

        @JacksonXmlProperty(localName = "templateid")
        private String templateId;

        private String url;

        @JacksonXmlProperty(localName = "iconurl")
        private String iconUrl;

        @JacksonXmlProperty(localName = "receivertitle")
        private String receiverTitle;

        @JacksonXmlProperty(localName = "sendertitle")
        private String senderTitle;

        @JacksonXmlProperty(localName = "scenetext")
        private String sceneText;

        @JacksonXmlProperty(localName = "senderdes")
        private String senderDes;

        @JacksonXmlProperty(localName = "receiverdes")
        private String receiverDes;

        @JacksonXmlProperty(localName = "nativeurl")
        private String nativeUrl;

        @JacksonXmlProperty(localName = "sceneid")
        private Integer sceneId;

        @JacksonXmlProperty(localName = "innertype")
        private Integer innerType;

        @JacksonXmlProperty(localName = "paymsgid")
        private String payMsgId;

        @JacksonXmlProperty(localName = "expressionurl")
        private String expressionUrl;

        @JacksonXmlProperty(localName = "expressiontype")
        private String expressionType;

        @JacksonXmlProperty(localName = "locallogoicon")
        private String localLogoIcon;

        /**
         * 失效的时间戳，单位:秒
         */
        @JacksonXmlProperty(localName = "invalidtime")
        private Long invalidTime;

        // 作用未知
        private String broaden;
    }

    @Data
    public static class Emoji {
        private String md5;

        private Integer type;

        private Integer width;

        private Integer height;

        private Integer len;

        private String aeskey;
        
        @JacksonXmlProperty(localName = "cndurl")
        private String cndUrl;
        
        @JacksonXmlProperty(localName = "encrypturl")
        private String encryptUrl;
        
        @JacksonXmlProperty(localName = "externurl")
        private String externUrl;
        
        @JacksonXmlProperty(localName = "externmd5")
        private String externMd5;
        
        @JacksonXmlProperty(localName = "productid")
        private String productId;
        
        @JacksonXmlProperty(localName = "designerid")
        private String designerId;
        
        @JacksonXmlProperty(localName = "attachedtext")
        private String attachedText;
    }
}