/**
 * kuaike.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.resp;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title RcLogListDto
 * @author yanmaoyuan
 * @date 2020年4月27日
 * @version 1.0
 */
@Data
public class RcLogListDto implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
     * 风控日志ID
     */
    private Long id;

    /**
     * 风控方案
     */
    private RcLogPlanDto rcPlan;

    /**
     * 触发群Name
     */
    private RcChatroomDto chatroom;

    /**
     * 群主微信号
     */
    private RcWechatAccountDto chatroomOwner;

    /**
     * 被处理人微信号
     */
    private RcWechatDto chatroomMember;

    /**
     * 触发惩罚的消息ID
     */
    private String msgSvrId;

    /**
     * 触发惩罚的消息内容
     */
    private String msg;

    /**
     * 原因
     */
    private String reason;

    /**
     * 1：拉黑并踢出；2：踢出所有群；3：警告
     */
    private Integer dealType;

    /**
     * 处理状态, 0:待处理；1：处理成功；2：部分成功；3：失败
     */
    private Integer dealStatus;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 是否撤销(0:未撤销; 1:已撤销)
     */
    private Integer isUndo;

    /**
     * 撤销信息
     */
    private RcUndoDto undo;

    /**
     * 是否配置拉黑
     */
    private Integer enableBlackList;
    /**
     * 当前拉黑状态
     */
    private Integer blackListStatus;
}
