package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.rc.service.common.dto.Operator;

import com.google.common.base.Preconditions;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class RcResultReq extends Operator {

    private static final long serialVersionUID = 1L;

    /**
     * 风控日志ID
     */
    private Long resultId;

    private Integer dealOpType;

    private Integer status;

    private PageDto pageDto;

    public void validate(){
        Preconditions.checkArgument(resultId != null,"resultId can not be null");
    }
}
