package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.rc.service.common.dto.Operator;

import java.util.Collection;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class RcResultListReq extends Operator {

    private static final long serialVersionUID = 1L;

    /**
     * 风控方案查询: 方案名称,方案编号
     */
    private String rcQuery;

    /**
     * 群主查询: 群主昵称, 群主微信号
     */
    private Collection<String> ownerWechatIds;

    /**
     * 被处理群成员查询: 微信昵称,微信号
     */
    private String memberQuery;

    /**
     * 分页查询参数
     */
    private PageDto pageDto;
    /**
     * 群昵称
     */
    private String chatRoomNickName;

    private String chatRoomId;
    /**
     * 处理类型
     */
    private Integer dealType;

    private Integer isBlackList;
}
