/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.rc.service.riskControl.enums.RcDealType;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @title RcEvent
 * @author yanmaoyuan
 * @date 2020年6月24日
 * @version 1.0
 */
@Data
public class RcEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long rcId;// 触发了哪个风控方案

    private String wechatId;// 上报这个消息的机器人ID

    private Long businessCustomerId;// 机器人所属的商户ID

    private String requestId;// 消息的requestId

    private String msgSvrId;// 消息的msgSvrId

    private String content; //消息

    private Integer msgType;

    private String chatRoomId;// 群ID

    private String ownerId;// 群主ID

    private String memberId;// 群成员ID

    private String reason;// 检测的行为类型

    private String checkType;// 检测的行为类型

    private Integer dealType;// 处理方式

    private Boolean enableBlacklist;// 踢出时自动添加到黑名单。

    private String kickNotice;// 踢人文案

    private String warnNotice;// 警告文案

    private Date createTime; //消息时间

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(wechatId), "wechatId not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(requestId), "requestId not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(msgSvrId), "msgSvrId not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(chatRoomId), "chatRoomId not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(ownerId), "ownerId not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(memberId), "memberId not null");

        Preconditions.checkArgument(Objects.nonNull(dealType), "dealType not null");
        Preconditions.checkArgument(Objects.nonNull(rcId), "rcId not null");
        Preconditions.checkArgument(Objects.nonNull(businessCustomerId), "businessCustomerId not null");

        RcDealType type = RcDealType.getType(dealType);
        Preconditions.checkArgument(Objects.nonNull(type), "dealType illegal");

        switch (type) {
            case WARN :{
                Preconditions.checkArgument(StringUtils.isNotBlank(warnNotice), "告警信息不能为空");
                break;
            }
            case KICK_ALL_NOTICE: {
                Preconditions.checkArgument(Objects.nonNull(enableBlacklist), "是否拉黑配置不能为空");
                Preconditions.checkArgument(StringUtils.isNotBlank(kickNotice), "踢人通告不能为空");
                break;
            }
            case KICK_ALL: {
                Preconditions.checkArgument(Objects.nonNull(enableBlacklist), "是否拉黑配置不能为空");
                break;
            }
        }
    }
}
