package com.kuaike.skynet.rc.service.riskControl;

import com.kuaike.skynet.rc.service.riskControl.dto.req.RcChatroomListReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanActiveReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanCheckReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanIdReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanQueryReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanReq;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcChatroomListRsp;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcDetailDto;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcPlanCheckRsp;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcPlanListRsp;

import java.util.List;

/**
 * 风控方案管理接口
 * 
 * @title RcPlanService
 * @author yanmaoyuan
 * @date 2020年7月1日
 * @version 1.0
 */
public interface RcPlanService {

    /**
     * 初始化系统所有商户的默认方案
     */
    void init();

    /**
     * 查询风控方案列表
     * @param params
     * @return
     */
    RcPlanListRsp queryList(RcPlanQueryReq params);

    /**
     * 删除风控方案
     * @param params
     */
    void delete(RcPlanIdReq params);

    /**
     * 查询风控方案详情
     * @param params
     * @return
     */
    RcDetailDto detail(RcPlanIdReq params);

    /**
     * 查询风控方案关联的群信息
     * 
     * @param params
     * @return
     */
    RcChatroomListRsp chatroomList(RcChatroomListReq params);

    /**
     * 新建风控方案
     * 
     * @param param 方案参数
     */
    Long add(RcPlanReq param);

    /**
     * 编辑风控方案
     * 
     * @param param 方案参数
     */
    void modify(RcPlanReq param);

    /**
     * 开启关闭方案
     * @param params
     */
    void active(RcPlanActiveReq params);

    /**
     * 查询微信号设置的风控方案
     * 
     * @param params
     * @return
     */
    List<RcPlanCheckRsp> check(RcPlanCheckReq params);

    /**
     * 根据businessCustomerId查询风控方案
     * @param businessCustomerId
     * @return
     */
    RcDetailDto getBusinessCustomerPlan(Long businessCustomerId);
}