/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.rc.service.riskControl.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public enum RcCheckType {
    TEXT("text", "\u53d1\u5e7f\u544a", "\u53d1\u4e86\u654f\u611f\u8bcd"),
    BCARD("bcard", "\u53d1\u5e7f\u544a", "\u53d1\u540d\u7247"),
    VIDEO("video", "\u53d1\u5e7f\u544a", "\u53d1\u5c0f\u89c6\u9891"),
    LINK("link", "\u53d1\u5e7f\u544a", "\u53d1\u94fe\u63a5\u5206\u4eab"),
    MINI_PROGRAM("miniProgram", "\u53d1\u5e7f\u544a", "\u53d1\u5c0f\u7a0b\u5e8f"),
    RATE_LIMIT("rateLimit", "\u5237\u5c4f", "\u8fde\u7eed%d\u79d2\u53d1\u9001\u4e86%d\u6761\u6d88\u606f"),
    LINE_LIMIT("lineLimit", "\u5237\u5c4f", "\u4fe1\u606f\u5927\u4e8e%d\u884c"),
    CHAR_LIMIT("charLimit", "\u5237\u5c4f", "\u4fe1\u606f\u957f\u5ea6\u8d85\u8fc7%d\u5b57"),
    NICKNAME("nickname", "\u6635\u79f0\u5305\u542b\u654f\u611f\u8bcd", "\u6635\u79f0\u5305\u542b\u654f\u611f\u8bcd"),
    ADD_ROBOT("addRobot", "\u79c1\u52a0\u5c0f\u53f7", "\u79c1\u52a0\u5c0f\u53f7"),
    JOIN_BY_QRCODE("joinByQrcode", "\u626b\u7801\u5165\u7fa4", "\u975e\u767d\u540d\u5355\u7528\u6237\u63d0\u4f9b\u4e8c\u7ef4\u7801\u5165\u7fa4"),
    JOIN_BY_INVITE("joinByInvite", "\u9080\u8bf7\u5165\u7fa4", "\u975e\u767d\u540d\u5355\u7528\u6237\u9080\u8bf7\u4ed6\u4eba\u5165\u7fa4");

    private static final Map<String, RcCheckType> CACHE;
    private static final List<RcCheckType> MESSAGE_TYPES;
    private static final List<RcCheckType> ANTI_HARNESS_TYPES;
    private static final List<RcCheckType> ANTI_JOIN_GROUP_TYPES;
    private String name;
    private String desc;
    private String reason;

    private RcCheckType(String name, String desc, String reason) {
        this.name = name;
        this.desc = desc;
        this.reason = reason;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getReason() {
        return this.reason;
    }

    public static RcCheckType getType(String type) {
        return CACHE.get(type);
    }

    public static List<RcCheckType> getMessageTypes() {
        return Lists.newArrayList(MESSAGE_TYPES);
    }

    public static List<RcCheckType> getAntiHarnessTypes() {
        return Lists.newArrayList(ANTI_HARNESS_TYPES);
    }

    public static List<RcCheckType> getAntiJoinGroupTypes() {
        return Lists.newArrayList(ANTI_JOIN_GROUP_TYPES);
    }

    static {
        MESSAGE_TYPES = Lists.newArrayList((Object[])new RcCheckType[]{TEXT, BCARD, LINK, VIDEO, MINI_PROGRAM});
        ANTI_HARNESS_TYPES = Lists.newArrayList((Object[])new RcCheckType[]{RATE_LIMIT, LINE_LIMIT, CHAR_LIMIT});
        ANTI_JOIN_GROUP_TYPES = Lists.newArrayList((Object[])new RcCheckType[]{JOIN_BY_QRCODE, JOIN_BY_INVITE});
        CACHE = Maps.newHashMap();
        for (RcCheckType t : RcCheckType.values()) {
            CACHE.put(t.name, t);
        }
    }
}

