/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.rc.service.riskControl.dto;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.rc.service.riskControl.enums.RcDealType;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RcEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long rcId;
    private String wechatId;
    private Long businessCustomerId;
    private String requestId;
    private String msgSvrId;
    private String content;
    private Integer msgType;
    private String chatRoomId;
    private String ownerId;
    private String memberId;
    private String reason;
    private String checkType;
    private Integer dealType;
    private Boolean enableBlacklist;
    private String kickNotice;
    private String warnNotice;
    private Date createTime;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.wechatId), (Object)"wechatId not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.requestId), (Object)"requestId not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.msgSvrId), (Object)"msgSvrId not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.chatRoomId), (Object)"chatRoomId not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.ownerId), (Object)"ownerId not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.memberId), (Object)"memberId not null");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.dealType), (Object)"dealType not null");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.rcId), (Object)"rcId not null");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.businessCustomerId), (Object)"businessCustomerId not null");
        RcDealType type = RcDealType.getType(this.dealType);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)type), (Object)"dealType illegal");
        switch (type) {
            case WARN: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.warnNotice), (Object)"\u544a\u8b66\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case KICK_ALL_NOTICE: {
                Preconditions.checkArgument((boolean)Objects.nonNull(this.enableBlacklist), (Object)"\u662f\u5426\u62c9\u9ed1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.kickNotice), (Object)"\u8e22\u4eba\u901a\u544a\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case KICK_ALL: {
                Preconditions.checkArgument((boolean)Objects.nonNull(this.enableBlacklist), (Object)"\u662f\u5426\u62c9\u9ed1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public Long getRcId() {
        return this.rcId;
    }

    public String getWechatId() {
        return this.wechatId;
    }

    public Long getBusinessCustomerId() {
        return this.businessCustomerId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getMsgSvrId() {
        return this.msgSvrId;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getMsgType() {
        return this.msgType;
    }

    public String getChatRoomId() {
        return this.chatRoomId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getReason() {
        return this.reason;
    }

    public String getCheckType() {
        return this.checkType;
    }

    public Integer getDealType() {
        return this.dealType;
    }

    public Boolean getEnableBlacklist() {
        return this.enableBlacklist;
    }

    public String getKickNotice() {
        return this.kickNotice;
    }

    public String getWarnNotice() {
        return this.warnNotice;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setRcId(Long rcId) {
        this.rcId = rcId;
    }

    public void setWechatId(String wechatId) {
        this.wechatId = wechatId;
    }

    public void setBusinessCustomerId(Long businessCustomerId) {
        this.businessCustomerId = businessCustomerId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setMsgSvrId(String msgSvrId) {
        this.msgSvrId = msgSvrId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMsgType(Integer msgType) {
        this.msgType = msgType;
    }

    public void setChatRoomId(String chatRoomId) {
        this.chatRoomId = chatRoomId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public void setDealType(Integer dealType) {
        this.dealType = dealType;
    }

    public void setEnableBlacklist(Boolean enableBlacklist) {
        this.enableBlacklist = enableBlacklist;
    }

    public void setKickNotice(String kickNotice) {
        this.kickNotice = kickNotice;
    }

    public void setWarnNotice(String warnNotice) {
        this.warnNotice = warnNotice;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RcEvent)) {
            return false;
        }
        RcEvent other = (RcEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$rcId = this.getRcId();
        Long other$rcId = other.getRcId();
        if (this$rcId == null ? other$rcId != null : !((Object)this$rcId).equals(other$rcId)) {
            return false;
        }
        String this$wechatId = this.getWechatId();
        String other$wechatId = other.getWechatId();
        if (this$wechatId == null ? other$wechatId != null : !this$wechatId.equals(other$wechatId)) {
            return false;
        }
        Long this$businessCustomerId = this.getBusinessCustomerId();
        Long other$businessCustomerId = other.getBusinessCustomerId();
        if (this$businessCustomerId == null ? other$businessCustomerId != null : !((Object)this$businessCustomerId).equals(other$businessCustomerId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$msgSvrId = this.getMsgSvrId();
        String other$msgSvrId = other.getMsgSvrId();
        if (this$msgSvrId == null ? other$msgSvrId != null : !this$msgSvrId.equals(other$msgSvrId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Integer this$msgType = this.getMsgType();
        Integer other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !((Object)this$msgType).equals(other$msgType)) {
            return false;
        }
        String this$chatRoomId = this.getChatRoomId();
        String other$chatRoomId = other.getChatRoomId();
        if (this$chatRoomId == null ? other$chatRoomId != null : !this$chatRoomId.equals(other$chatRoomId)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$memberId = this.getMemberId();
        String other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$checkType = this.getCheckType();
        String other$checkType = other.getCheckType();
        if (this$checkType == null ? other$checkType != null : !this$checkType.equals(other$checkType)) {
            return false;
        }
        Integer this$dealType = this.getDealType();
        Integer other$dealType = other.getDealType();
        if (this$dealType == null ? other$dealType != null : !((Object)this$dealType).equals(other$dealType)) {
            return false;
        }
        Boolean this$enableBlacklist = this.getEnableBlacklist();
        Boolean other$enableBlacklist = other.getEnableBlacklist();
        if (this$enableBlacklist == null ? other$enableBlacklist != null : !((Object)this$enableBlacklist).equals(other$enableBlacklist)) {
            return false;
        }
        String this$kickNotice = this.getKickNotice();
        String other$kickNotice = other.getKickNotice();
        if (this$kickNotice == null ? other$kickNotice != null : !this$kickNotice.equals(other$kickNotice)) {
            return false;
        }
        String this$warnNotice = this.getWarnNotice();
        String other$warnNotice = other.getWarnNotice();
        if (this$warnNotice == null ? other$warnNotice != null : !this$warnNotice.equals(other$warnNotice)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RcEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $rcId = this.getRcId();
        result = result * 59 + ($rcId == null ? 43 : ((Object)$rcId).hashCode());
        String $wechatId = this.getWechatId();
        result = result * 59 + ($wechatId == null ? 43 : $wechatId.hashCode());
        Long $businessCustomerId = this.getBusinessCustomerId();
        result = result * 59 + ($businessCustomerId == null ? 43 : ((Object)$businessCustomerId).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $msgSvrId = this.getMsgSvrId();
        result = result * 59 + ($msgSvrId == null ? 43 : $msgSvrId.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Integer $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : ((Object)$msgType).hashCode());
        String $chatRoomId = this.getChatRoomId();
        result = result * 59 + ($chatRoomId == null ? 43 : $chatRoomId.hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $checkType = this.getCheckType();
        result = result * 59 + ($checkType == null ? 43 : $checkType.hashCode());
        Integer $dealType = this.getDealType();
        result = result * 59 + ($dealType == null ? 43 : ((Object)$dealType).hashCode());
        Boolean $enableBlacklist = this.getEnableBlacklist();
        result = result * 59 + ($enableBlacklist == null ? 43 : ((Object)$enableBlacklist).hashCode());
        String $kickNotice = this.getKickNotice();
        result = result * 59 + ($kickNotice == null ? 43 : $kickNotice.hashCode());
        String $warnNotice = this.getWarnNotice();
        result = result * 59 + ($warnNotice == null ? 43 : $warnNotice.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "RcEvent(rcId=" + this.getRcId() + ", wechatId=" + this.getWechatId() + ", businessCustomerId=" + this.getBusinessCustomerId() + ", requestId=" + this.getRequestId() + ", msgSvrId=" + this.getMsgSvrId() + ", content=" + this.getContent() + ", msgType=" + this.getMsgType() + ", chatRoomId=" + this.getChatRoomId() + ", ownerId=" + this.getOwnerId() + ", memberId=" + this.getMemberId() + ", reason=" + this.getReason() + ", checkType=" + this.getCheckType() + ", dealType=" + this.getDealType() + ", enableBlacklist=" + this.getEnableBlacklist() + ", kickNotice=" + this.getKickNotice() + ", warnNotice=" + this.getWarnNotice() + ", createTime=" + this.getCreateTime() + ")";
    }
}

