/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @title RcDealOp
 * @author yanmaoyuan
 * @date 2020年6月16日
 * @version 1.0
 */
public enum RcDealOp {
    ban(1, "拉黑"),
    kick(2, "踢人"),
    warn(3, "告警"),
    kickAll(2, "踢出所有群"),
    kickNotice(5, "发送踢人公告"),

    kickAndSendNotice(6, "踢人并且发送公告"),
    ;

    private int value;

    private String desc;

    private final static Map<Integer, RcDealOp> CACHE;

    static {
        CACHE = Maps.newHashMap();
        for (RcDealOp e : values()) {
            CACHE.put(e.value, e);
        }
    }

    private RcDealOp(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }


    public static RcDealOp getType(Integer dealType) {
        return CACHE.get(dealType);
    }
}
