/**
 * Kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.resp;

import java.io.Serializable;

import lombok.Data;

/**
 * 检测微信号是否已经设置过风控方案，返回已有风控方案的id、code、name
 * 
 * @title RcPlanCheckRsp
 * @author yanmaoyuan
 * @date 2020年4月26日
 * @version 1.0
 */
@Data
public class RcPlanCheckRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    // 微信号
    private String wechatId;

    // 风控方案ID
    private Long id;

    // 风控方案编号
    private String code;

    // 风控方案名称
    private String name;

    // 方案是否开启
    private Boolean enabled;

    /**
     * 方案的级别，参考: {@link com.kuaike.skynet.rc.service.riskControl.enums.RcPlanLevel}
     */
    private Integer level;
}
