/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title RcRuleListItem
 * @author yanmaoyuan
 * @date 2020年6月16日
 * @version 1.0
 */
@Data
public class RcRuleListItem implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 敏感行为的类型
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcCheckType
     */
    private String type;// 检测的类型

    private Boolean enabled;

    /**
     * 群消息检测，文本消息中的敏感词
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcCheckType#TEXT
     */
    private List<String> words;

    /**
     * 防骚扰检测时间窗口（秒）
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcCheckType#RATE_LIMIT
     */
    private Integer second = 0;

    /**
     * 防骚扰检测消息阈值个数
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcCheckType#RATE_LIMIT
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcCheckType#LINE_LIMIT
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcCheckType#CHAR_LIMIT
     */
    private Integer count = 0;
}