/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import java.io.Serializable;

import lombok.Data;

/**
 * 风控规则
 * 
 * @title RcRuleDto
 * @author yanmaoyuan
 * @date 2020年6月30日
 * @version 1.0
 */
@Data
public class RcRuleDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 群成员触发风控敏感行为后的处理方式。
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcDealType
     */
    private Integer dealType;

    /**
     * 一旦触发需要执行踢人的操作后，是否要自动把该成员加入黑名单。
     */
    private Boolean enableBlacklist;

}