/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcWechatDto;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 私加小号检测
 * 
 * @title RcRuleAddRobotDto
 * @author yanmaoyuan
 * @date 2020年7月1日
 * @version 1.0
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class RcRuleAddRobotDto extends RcRuleDto {

    private static final long serialVersionUID = 1L;

    private Boolean enabled;

    /**
     * 风控方案关联的小号(必须是氛围号)
     */
    private List<String> wechatIds;

    /**
     * 小号的信息(用于返回给前端展示)
     */
    private List<RcWechatDto> wechatList;
}
