package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.skynet.rc.service.common.dto.Operator;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class RcPlanReq extends Operator {

    private static final long serialVersionUID = 1L;

    /**
     * 方案ID
     */
    private Long id;

    /**
     * 方案名称
     */
    private String name;

    /**
     * 方案的激活状态
     */
    private Boolean enabled;

    /**
     * 应用的群ID
     */
    private String chatroomId;

    /**
     * 适用的微信群
     */
    private List<String> chatroomIds;

    /**
     * 适用微信群主
     */
    private List<String> hosts;

    /**
     * 防广告
     */
    private RcRuleListDto message;
    
    /**
     * 昵称检测
     */
    private RcRuleNicknameDto nickname;

    /**
     * 防骚扰
     */
    private RcRuleListDto antiHarness;
    
    /**
     * 私加小号
     */
    private RcRuleAddRobotDto addRobot;

    /**
     * 防入群
     */
    private RcRuleAntiJoinGroupDto antiJoinGroup;

    /**
     * 踢人通告
     */
    private String kickNotice;

    /**
     * 警告通告
     */
    private String warnNotice;
}
