/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.rc.service.common.dto.Operator;

import java.util.Collection;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title RcChatroomListReq
 * @author yanmaoyuan
 * @date 2020年7月4日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RcChatroomListReq extends Operator {

    private static final long serialVersionUID = 1L;

    // 风控方案ID
    private Long id;

    // 群主的微信ID
    private String ownerWechatId;

    // 群名(模糊搜索)
    private String chatRoomName;
    
    // 群分组ID
    private Collection<Long> queryMutilGroupIds;

    // 群成员数最小
    private Integer memberCountMin;
    
    // 群成员数最大
    private Integer memberCountMax;

    // 分页查询参数
    private PageDto pageDto;
}