package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.google.common.base.Preconditions;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class PullRcWordReq implements Serializable {

    private static final long serialVersionUID = -5414650943777779699L;
    /**
     * wechatId
     */
    String wechatId;
    /**
     * 商户ID
     */
    Long buId;
    /**
     * 微信群id列表; 为空查询wechatId所有的群风控方案
     */
    List<String> chatRoomIds;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(wechatId),"wechatId is null or empty");
        Preconditions.checkArgument(buId!=null,"buId is null");
    }
}
