/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.enums;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AutoReplyMessageType implements EnumService
{
    MATERIAL(0, "\u7d20\u6750"),
    TEXT(1, "\u6587\u672c"),
    IMAGE(2, "\u56fe\u7247"),
    B_CARD(3, "\u540d\u7247"),
    FILE(9, "\u6587\u4ef6"),
    LINK(10, "\u94fe\u63a5"),
    VOICE(34, "\u8bed\u97f3"),
    VIDEO(43, "\u89c6\u9891"),
    DRAINAGE(101, "\u7fa4\u5f15\u6d41(\u6d41\u91cf\u6f0f\u6597)"),
    FISSION(102, "\u7fa4\u88c2\u53d8"),
    JOIN_GROUP_CARD(103, "\u52a0\u7fa4\u5361\u7247"),
    MINI_PROGRAM(104, "\u5c0f\u7a0b\u5e8f"),
    OWNER_BCARD(105, "\u7fa4\u4e3b\u4e2a\u4eba\u540d\u7247"),
    CONTACT_BCARD(106, "\u7fa4\u4e3b\u597d\u53cb\u7684\u4e2a\u4eba\u540d\u7247"),
    OFFICIAL_NEWS(201, "\u516c\u4f17\u53f7\u56fe\u6587"),
    OFFICIAL_ACTI(202, "\u516c\u4f17\u53f7\u88c2\u53d8");

    private static final Map<Integer, AutoReplyMessageType> MAP;
    private final int value;
    private final String desc;

    private AutoReplyMessageType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyMessageType getType(Integer value) {
        return MAP.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Integer getValueByDesc(String desc) {
        for (AutoReplyMessageType type : MAP.values()) {
            if (!type.getDesc().equals(desc)) continue;
            return type.getValue();
        }
        return null;
    }

    public static String getDescByValue(Integer value) {
        AutoReplyMessageType type = AutoReplyMessageType.getType(value);
        if (type != null) {
            return type.getDesc();
        }
        return null;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(AutoReplyMessageType.values()).collect(Collectors.toMap(AutoReplyMessageType::getValue, Function.identity())));
    }
}

