/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.wechat.impl;

import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechat;
import com.kuaike.skynet.logic.dal.reply.enums.LogicWechatConfigType;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountMapper;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyIdReqDto;
import com.kuaike.skynet.logic.service.wechat.PassiveAddFriendConfService;
import com.kuaike.skynet.logic.service.wechat.dto.req.PassiveAddFriendConfig;
import com.kuaike.skynet.logic.service.wechat.dto.req.PassiveAddFriendListReqDto;
import com.kuaike.skynet.logic.service.wechat.dto.req.PassiveAddFriendModelDto;
import com.kuaike.skynet.logic.service.wechat.dto.req.PassiveAddFriendWechatConfDto;
import com.kuaike.skynet.logic.service.wechat.dto.resp.PassiveAddFriendListRespDto;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PassiveAddFriendConfServiceImpl
implements PassiveAddFriendConfService {
    private static final Logger log = LoggerFactory.getLogger(PassiveAddFriendConfServiceImpl.class);
    @Autowired
    private LogicAutoReplyWechatMapper logicAutoReplyWechatMapper;
    @Autowired
    private WechatAccountMapper wechatAccountMapper;

    public PassiveAddFriendListRespDto list(PassiveAddFriendListReqDto passiveAddFriendListReqDto) {
        log.info("PassiveAddFriendConfServiceImpl list:{}", (Object)passiveAddFriendListReqDto);
        Preconditions.checkNotNull((Object)passiveAddFriendListReqDto, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        passiveAddFriendListReqDto.validate();
        PassiveAddFriendListRespDto respDto = new PassiveAddFriendListRespDto();
        int count = this.wechatAccountMapper.queryCountByUserIdsNameQuery((Collection)passiveAddFriendListReqDto.getUserIds(), passiveAddFriendListReqDto.getWechatId(), passiveAddFriendListReqDto.getQuery());
        passiveAddFriendListReqDto.getPageDto().setCount(Integer.valueOf(count));
        respDto.setPageDto(passiveAddFriendListReqDto.getPageDto());
        if (count == 0) {
            return respDto;
        }
        List wechatLogicConfigDtos = this.wechatAccountMapper.queryListByUserIdsNameQuery((Collection)passiveAddFriendListReqDto.getUserIds(), passiveAddFriendListReqDto.getWechatId(), Integer.valueOf(passiveAddFriendListReqDto.getPageDto().getOffset()), passiveAddFriendListReqDto.getPageDto().getPageSize(), passiveAddFriendListReqDto.getTimeSort(), passiveAddFriendListReqDto.getQuery());
        List passiveAddFriendWechatConfDtos = wechatLogicConfigDtos.stream().map(wechatLogicConfigDto -> {
            PassiveAddFriendWechatConfDto confDto = (PassiveAddFriendWechatConfDto)BeanUtil.convert((Object)wechatLogicConfigDto, PassiveAddFriendWechatConfDto.class, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)wechatLogicConfigDto.getExtendConfig())) {
                try {
                    PassiveAddFriendConfig logicWechatPassiveAddFriendConfig = (PassiveAddFriendConfig)JacksonUtil.str2Obj((String)wechatLogicConfigDto.getExtendConfig(), PassiveAddFriendConfig.class);
                    confDto.setPassiveAddFriendCheckFlag(logicWechatPassiveAddFriendConfig.getPassiveAddFriendCheckFlag());
                    confDto.setWeworkAddFriendFlag(logicWechatPassiveAddFriendConfig.getWeworkAddFriendFlag());
                }
                catch (IOException e) {
                    confDto.setPassiveAddFriendCheckFlag(Boolean.valueOf(true));
                    log.info("\u5e8f\u5217\u5316\u51fa\u9519:{}", (Throwable)e);
                }
            }
            if (Objects.isNull(confDto.getPassiveAddFriendCheckFlag())) {
                confDto.setPassiveAddFriendCheckFlag(Boolean.valueOf(true));
            }
            if (Objects.isNull(confDto.getWeworkAddFriendFlag())) {
                confDto.setWeworkAddFriendFlag(Boolean.valueOf(false));
            }
            return confDto;
        }).collect(Collectors.toList());
        respDto.setRespList(passiveAddFriendWechatConfDtos);
        return respDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(PassiveAddFriendModelDto passiveAddFriendModelDto) {
        log.info("PassiveAddFriendConfServiceImpl addOrMod, reqDto:{}", (Object)passiveAddFriendModelDto);
        Preconditions.checkNotNull((Object)passiveAddFriendModelDto, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        passiveAddFriendModelDto.validate();
        PassiveAddFriendConfig config = new PassiveAddFriendConfig();
        config.setPassiveAddFriendCheckFlag(passiveAddFriendModelDto.getPassiveAddFriendCheckFlag());
        if (Objects.isNull(passiveAddFriendModelDto.getWeworkAddFriendFlag())) {
            config.setWeworkAddFriendFlag(passiveAddFriendModelDto.getWeworkAddFriendFlag());
        } else {
            config.setWeworkAddFriendFlag(passiveAddFriendModelDto.getWeworkAddFriendFlag());
        }
        LogicAutoReplyWechat logicAutoReplyWechat = new LogicAutoReplyWechat();
        logicAutoReplyWechat.setType(Integer.valueOf(LogicWechatConfigType.PASSIVE_ADD_FRIEND_CONF.getValue()));
        logicAutoReplyWechat.setWechatId(passiveAddFriendModelDto.getWechatId());
        logicAutoReplyWechat.setExtendConfig(JacksonUtil.obj2Str((Object)config));
        logicAutoReplyWechat.setUpdateBy(passiveAddFriendModelDto.getOperatorId());
        logicAutoReplyWechat.setCreateBy(passiveAddFriendModelDto.getOperatorId());
        this.logicAutoReplyWechatMapper.replaceRecord(logicAutoReplyWechat);
    }

    public void delete(ReplyIdReqDto replyIdReqDto) {
        log.info("delete() in PassiveAddFriendConfServiceImpl, reqDto:{}", (Object)replyIdReqDto);
        Preconditions.checkNotNull((Object)replyIdReqDto, (Object)"replyIdReqDto is  null");
        replyIdReqDto.validate();
        this.logicAutoReplyWechatMapper.delByReplyId(replyIdReqDto.getId(), replyIdReqDto.getOperatorId(), Integer.valueOf(LogicWechatConfigType.PASSIVE_ADD_FRIEND_CONF.getValue()));
    }
}

