/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.dal.wechat.dto.WechatAccountDto;
import com.kuaike.skynet.logic.dal.wechat.enums.WechatAccountType;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountMapper;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.common.VersionedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WechatAccountCacheServiceImpl
extends VersionedCache
implements WechatAccountCacheService {
    private static final Logger log = LoggerFactory.getLogger(WechatAccountCacheServiceImpl.class);
    private Map<String, WechatAccountDto> cache = Collections.emptyMap();
    private List<WechatAccountDto> list = Collections.emptyList();
    private Set<String> robotWechatIds = Collections.emptySet();
    private Map<Integer, Set<String>> typedAccount = Collections.emptyMap();
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.wechatAccountVersion:wechat_account_version}")
    private String versionRedisKey;

    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    protected Long getExpiredInSecond() {
        return 300L;
    }

    protected void initialize() {
        this.list = this.wechatAccountMapper.getAll();
        if (CollectionUtils.isEmpty(this.list)) {
            this.cache = Collections.emptyMap();
            this.robotWechatIds = Collections.emptySet();
            this.typedAccount = Collections.emptyMap();
        } else {
            this.cache = this.list.stream().collect(Collectors.toMap(WechatAccountDto::getWechatId, Function.identity()));
            this.robotWechatIds = this.list.stream().map(WechatAccountDto::getWechatId).collect(Collectors.toSet());
            this.typedAccount = this.list.stream().filter(it -> it.getType() != null).collect(Collectors.groupingBy(WechatAccountDto::getType, Collectors.mapping(WechatAccountDto::getWechatId, Collectors.toSet())));
        }
    }

    @Override
    public void newVersion() {
        super.reset();
    }

    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    @Override
    public WechatAccountDto getAccount(String wechatId) {
        return this.cache.get(wechatId);
    }

    @Override
    public Long getBusinessCustomerId(String wechatId) {
        WechatAccountDto dto = this.cache.get(wechatId);
        if (dto == null) {
            return null;
        }
        return dto.getBusinessCustomerId();
    }

    @Override
    public boolean isRobot(String wechatId) {
        return this.cache.containsKey(wechatId);
    }

    @Override
    public boolean isRobot(Long businessCustomerId, String wechatId) {
        if (businessCustomerId == null) {
            log.warn("businessCustomerId is null");
            return false;
        }
        WechatAccountDto dto = this.cache.get(wechatId);
        if (dto == null) {
            return false;
        }
        return businessCustomerId.equals(dto.getBusinessCustomerId());
    }

    @Override
    public List<String> getRobotWechatIds(Collection<String> wechatIds) {
        log.info("get robot from wechatIds:{}", wechatIds);
        if (CollectionUtils.isEmpty(wechatIds)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        for (String wechatId : wechatIds) {
            if (!set.add(wechatId) || !this.robotWechatIds.contains(wechatId)) continue;
            list.add(wechatId);
        }
        return list;
    }

    @Override
    public List<String> queryRobotWechatIds(Long businessCustomerId, Collection<String> wechatIds) {
        if (businessCustomerId == null) {
            log.warn("businessCustomerId is null");
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(wechatIds)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)wechatIds.size());
        for (String wechatId : wechatIds) {
            WechatAccountDto dto = this.cache.get(wechatId);
            if (dto == null || !businessCustomerId.equals(dto.getBusinessCustomerId())) continue;
            result.add(wechatId);
        }
        return result;
    }

    @Override
    public void removeByType(Collection<String> wechatIds, WechatAccountType type) {
        log.info("remove type:{} from wechatIds={}", (Object)type, wechatIds);
        if (CollectionUtils.isEmpty(wechatIds)) {
            return;
        }
        Set<String> ids = this.typedAccount.get(type.getValue());
        if (CollectionUtils.isNotEmpty(ids)) {
            wechatIds.removeAll(ids);
        }
    }

    @Override
    public boolean isType(String wechatId, WechatAccountType type) {
        Set<String> ids = this.typedAccount.get(type.getValue());
        if (ids == null) {
            return false;
        }
        return ids.contains(wechatId);
    }

    @Override
    public List<WechatAccountDto> listAll() {
        return this.list;
    }
}

