/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.kuaike.skynet.logic.dal.collect.entity.CollectBlackList;
import com.kuaike.skynet.logic.dal.collect.mapper.CollectBlackListMapper;
import com.kuaike.skynet.logic.service.cache.BlacklistCacheService;
import com.kuaike.skynet.logic.service.common.VersionedCache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class BlacklistCacheServiceImpl
extends VersionedCache
implements BlacklistCacheService {
    private static final Logger log = LoggerFactory.getLogger(BlacklistCacheServiceImpl.class);
    private Map<Long, Set<String>> cache = Collections.emptyMap();
    @Autowired
    private CollectBlackListMapper collectBlackListMapper;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.blackListVersion:black_list_version}")
    private String versionRedisKey;

    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    protected Long getExpiredInSecond() {
        return 300L;
    }

    @Override
    public void newVersion() {
        super.reset();
    }

    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    protected void initialize() {
        CollectBlackList record = new CollectBlackList();
        record.setIsDel(Integer.valueOf(0));
        List list = this.collectBlackListMapper.select((Object)record);
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.cache = Collections.emptyMap();
        } else {
            this.cache = list.stream().collect(Collectors.groupingBy(CollectBlackList::getBussinessCustomerId, Collectors.mapping(CollectBlackList::getWechatId, Collectors.toSet())));
            log.debug("Load blacklist cache:{}", this.cache);
        }
    }

    @Override
    public boolean inBlacklist(Long businessCustomerId, String wechatId) {
        log.debug("query if wechatId={} in merchant={} 's black list", (Object)wechatId, (Object)businessCustomerId);
        Set<String> ids = this.cache.get(businessCustomerId);
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        return ids.contains(wechatId);
    }
}

