/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.skynet.logic.dal.reply.dto.AddFriendListParams;
import com.kuaike.skynet.logic.dal.reply.dto.JoinGroupListParams;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyCriteria;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechat;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechatCriteria;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechatRoom;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechatRoomCriteria;
import com.kuaike.skynet.logic.dal.reply.entity.LogicJoinGroupReplyConfig;
import com.kuaike.skynet.logic.dal.reply.enums.LogicWechatConfigType;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatRoomMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicJoinGroupReplyConfigMapper;
import com.kuaike.skynet.logic.dal.user.entity.User;
import com.kuaike.skynet.logic.dal.user.mapper.UserMapper;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.CommonReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.ReplyService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.IdAndNameExtendDto;
import com.kuaike.skynet.logic.service.reply.dto.LogicReplyDto;
import com.kuaike.skynet.logic.service.reply.dto.req.AddFriendReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.AddFriendReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.JoinGroupReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.JoinGroupReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyEnabledReq;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListRespDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyRoomWechatResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.RoomToRobotDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReplyServiceImpl
implements ReplyService {
    private static final Logger log = LoggerFactory.getLogger(ReplyServiceImpl.class);
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyWechatRoomMapper logicAutoReplyWechatRoomMapper;
    @Autowired
    private LogicAutoReplyWechatMapper logicAutoReplyWechatMapper;
    @Autowired
    private LogicJoinGroupReplyConfigMapper logicJoinGroupReplyConfigMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private CommonReplyService commonReplyService;

    public ReplyListRespDto list(ReplyListReqDto params) {
        log.info("query reply list with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getReplyType() != null ? 1 : 0) != 0, (Object)"type\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getPageDto() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> replies = params instanceof JoinGroupReplyListReqDto ? this.joinGroupReplyList((JoinGroupReplyListReqDto)params) : (params instanceof AddFriendReplyListReqDto ? this.wechatAddFriendReplyList((AddFriendReplyListReqDto)params) : Collections.emptyList());
        Set userIds = replies.stream().flatMap(a -> Stream.of(a.getCreateBy(), a.getUpdateBy())).collect(Collectors.toSet());
        List users = this.userMapper.selectByIds(userIds);
        Map userMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        replies.forEach(reply -> {
            User create = (User)userMap.get(reply.getCreateBy());
            IdAndNameExtendDto idAndNameExtendDto = new IdAndNameExtendDto();
            idAndNameExtendDto.setId(reply.getCreateBy());
            idAndNameExtendDto.setName(create != null ? create.getName() : "");
            idAndNameExtendDto.setNickName(create != null ? create.getNickName() : "");
            reply.setCreator(idAndNameExtendDto);
            User updator = (User)userMap.get(reply.getUpdateBy());
            IdAndNameExtendDto idAndNameExtendDto2 = new IdAndNameExtendDto();
            idAndNameExtendDto2.setId(reply.getUpdateBy());
            idAndNameExtendDto2.setName(updator != null ? updator.getName() : "");
            idAndNameExtendDto2.setNickName(updator != null ? updator.getNickName() : "");
            reply.setUpdator(idAndNameExtendDto2);
        });
        return this.getListRespDto(replies, params.getPageDto());
    }

    private ReplyListRespDto getListRespDto(List<ReplyListResp> respList, PageDto pageDto) {
        ReplyListRespDto respDto = new ReplyListRespDto();
        respDto.setRespList(respList);
        respDto.setPageDto(pageDto);
        return respDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(LogicReplyDto params) {
        log.info("add or mod reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getReplyMessage()), (Object)"replyMessage\u4e0d\u80fd\u4e3anull");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getReplyType() != null ? 1 : 0) != 0, (Object)"replyType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getRelationType() != null ? 1 : 0) != 0, (Object)"relationType\u4e0d\u80fd\u4e3a\u7a7a");
        if (params instanceof JoinGroupReplyReqDto) {
            JoinGroupReplyReqDto req = (JoinGroupReplyReqDto)params;
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)req.getChatRooms()), (Object)"\u9009\u62e9\u7684\u7fa4\u4e0d\u53ef\u4e3a\u7a7a");
            Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(req.getChatRooms());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatRoomIds), (Object)"\u9009\u62e9\u7684\u7fa4\u4e0d\u53ef\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)this.commonReplyService.validateChatRoomIds(req.getChatRooms()), (Object)"\u9009\u62e9\u7684\u7fa4\u4e0d\u53ef\u91cd\u590d");
            Preconditions.checkArgument((req.getTimeIntervalMin() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u5165\u7fa4\u56de\u590d\u65f6\u95f4\u95f4\u9694\u6700\u5c0f\u503c");
            Preconditions.checkArgument((req.getTimeIntervalMin() >= 30 && req.getTimeIntervalMin() <= 43200 ? 1 : 0) != 0, (Object)"\u5165\u7fa4\u56de\u590d\u65f6\u95f4\u95f4\u9694\u8303\u56f430~43200");
            Preconditions.checkArgument((req.getTimeIntervalMax() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u5165\u7fa4\u56de\u590d\u65f6\u95f4\u95f4\u9694\u6700\u5927\u503c");
            Preconditions.checkArgument((req.getTimeIntervalMax() >= 30 && req.getTimeIntervalMax() <= 43200 ? 1 : 0) != 0, (Object)"\u5165\u7fa4\u56de\u590d\u65f6\u95f4\u95f4\u9694\u8303\u56f430~43200");
            Preconditions.checkArgument((req.getTimeIntervalMin() <= req.getTimeIntervalMax() ? 1 : 0) != 0, (Object)"\u5165\u7fa4\u56de\u590d\u65f6\u95f4\u95f4\u9694\u7684\u6700\u5927\u503c\u5c0f\u4e8e\u6700\u5c0f\u503c");
            Preconditions.checkArgument((req.getMemberInterval() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u5165\u7fa4\u56de\u590d\u4eba\u6570\u95f4\u9694");
            Preconditions.checkArgument((req.getMemberInterval() >= 3 && req.getMemberInterval() <= 500 ? 1 : 0) != 0, (Object)"\u5165\u7fa4\u56de\u590d\u4eba\u6570\u95f4\u9694\u8303\u56f43~500");
        }
        Long autoReplyId = params.getId();
        LogicAutoReply reply = (LogicAutoReply)BeanUtil.convert((Object)params, LogicAutoReply.class, (String[])new String[0]);
        reply.setMerchantId(params.getBusinessCustomerId());
        String message = this.replyMessageDtoService.toReplyMessageStr(params.getReplyMessage());
        reply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        reply.setDigest(digest);
        if (autoReplyId != null) {
            reply.setId(autoReplyId);
            reply.setUpdateBy(params.getOperatorId());
            reply.setUpdateTime(new Date());
            reply.setNodeId(null);
            reply.setMerchantId(null);
            this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        } else {
            reply.setCreateBy(params.getOperatorId());
            reply.setUpdateBy(params.getOperatorId());
            this.logicAutoReplyMapper.insertSelective((Object)reply);
            autoReplyId = reply.getId();
        }
        if (params instanceof JoinGroupReplyReqDto) {
            this.logicAutoReplyWechatRoomMapper.delByReplyId(autoReplyId, params.getOperatorId());
            JoinGroupReplyReqDto req = (JoinGroupReplyReqDto)params;
            this.commonReplyService.addOrModReplyChatRoom(req.getChatRooms(), autoReplyId, req.getOperatorId(), req.getRoomWechatDtos());
            this.obsoleteLogicReply(req, autoReplyId);
            this.addOrModJoinReplyConfg(autoReplyId, req.getTimeIntervalMin(), req.getTimeIntervalMax(), req.getMemberInterval(), params.getOperatorId());
        }
        if (params instanceof AddFriendReplyReqDto) {
            this.addOrModReplyWechat((AddFriendReplyReqDto)params, autoReplyId);
            this.obsoleteLogicWechatReply((AddFriendReplyReqDto)params, autoReplyId);
        }
    }

    private void addOrModJoinReplyConfg(Long autoReplyId, Integer timeIntervalMin, Integer timeIntervalMax, Integer memberInterval, Long operatorId) {
        LogicJoinGroupReplyConfig config = this.logicJoinGroupReplyConfigMapper.getByAutoReplyId(autoReplyId);
        if (config != null) {
            config.setMemberInterval(memberInterval);
            config.setTimeIntervalMax(timeIntervalMax);
            config.setTimeIntervalMin(timeIntervalMin);
            config.setUpdateBy(operatorId);
            config.setUpdateTime(null);
            this.logicJoinGroupReplyConfigMapper.updateByPrimaryKeySelective((Object)config);
        } else {
            config = new LogicJoinGroupReplyConfig();
            config.setAutoReplyId(autoReplyId);
            config.setCreateBy(operatorId);
            config.setUpdateBy(operatorId);
            config.setMemberInterval(memberInterval);
            config.setTimeIntervalMax(timeIntervalMax);
            config.setTimeIntervalMin(timeIntervalMin);
            this.logicJoinGroupReplyConfigMapper.insertSelective((Object)config);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(ReplyIdReqDto params) {
        log.info("delete reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"\u5220\u9664\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        this.logicAutoReplyMapper.logicDeleteByPrimaryKeys(Collections.singleton(params.getId()), params.getOperatorId(), new Date());
        this.logicAutoReplyWechatRoomMapper.delByReplyId(params.getId(), params.getOperatorId());
        this.logicJoinGroupReplyConfigMapper.logicDeleteByAutoReplyId(params.getId(), params.getOperatorId());
        this.logicAutoReplyWechatMapper.delByReplyId(params.getId(), params.getOperatorId(), Integer.valueOf(LogicWechatConfigType.ADD_FRIEND_REPLY.getValue()));
        this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds(Collections.singleton(params.getId()), params.getOperatorId(), new Date());
    }

    public ReplyListResp detail(ReplyIdReqDto params) throws IllegalArgumentException, BusinessException {
        log.info("query reply detail with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        LogicAutoReply existReply = (LogicAutoReply)this.logicAutoReplyMapper.selectByPrimaryKey((Object)params.getId());
        ReplyListResp resp = (ReplyListResp)BeanUtil.convert((Object)existReply, ReplyListResp.class, (String[])new String[0]);
        resp.setEnabled(Integer.valueOf(existReply.getEnabled() == null ? 0 : existReply.getEnabled()));
        List<AutoReplyMessageDto> messageDtos = this.replyMessageDtoService.toAutoReplyMessageDtoList(existReply);
        resp.setReplyMessage(messageDtos);
        switch (AutoReplyRelationType.getType((int)existReply.getRelationType())) {
            case CHAT_ROOM: {
                List<Long> replyIds = Collections.singletonList(existReply.getId());
                List chatRoomList = this.logicAutoReplyWechatRoomMapper.queryByReplyIds(replyIds);
                List chatRooms = chatRoomList.stream().map(it -> new RoomToRobotDto(it.getWechatRoomName(), it.getWechatId())).collect(Collectors.toList());
                resp.setChatRooms(chatRooms);
                LogicJoinGroupReplyConfig config = this.logicJoinGroupReplyConfigMapper.getByAutoReplyId(params.getId());
                if (config == null) break;
                resp.setTimeIntervalMax(config.getTimeIntervalMax());
                resp.setTimeIntervalMin(config.getTimeIntervalMin());
                resp.setMemberInterval(config.getMemberInterval());
                break;
            }
            case WECHAT: {
                List logicAutoReplyWechatNickNameDtos = this.logicAutoReplyWechatMapper.queryByReplyIds(Collections.singletonList(existReply.getId()));
                List wechatIds = logicAutoReplyWechatNickNameDtos.stream().map(a -> a.getWechatId()).collect(Collectors.toList());
                resp.setWechatIds(wechatIds);
                break;
            }
            default: {
                log.warn("Unknown relation type, reply.id={}, relationType={}", (Object)existReply.getId(), (Object)existReply.getRelationType());
            }
        }
        return resp;
    }

    private List<ReplyListResp> wechatAddFriendReplyList(AddFriendReplyListReqDto params) {
        log.info("query add friend reply list with params={}", (Object)params);
        AddFriendListParams addFriendListParams = (AddFriendListParams)BeanUtil.convert((Object)params, AddFriendListParams.class, (String[])new String[0]);
        if (StringUtils.isBlank((CharSequence)addFriendListParams.getWechatId())) {
            addFriendListParams.setWechatId(null);
        }
        if (StringUtils.isBlank((CharSequence)addFriendListParams.getUserName())) {
            addFriendListParams.setUserName(null);
        }
        int count = this.logicAutoReplyMapper.countAddfriendListByParams(addFriendListParams);
        addFriendListParams.setCount(Integer.valueOf(count));
        if (count == 0) {
            return Collections.emptyList();
        }
        List replies = this.logicAutoReplyMapper.queryAddfriendListByParams(addFriendListParams);
        List replyIds = replies.stream().map(LogicAutoReply::getId).collect(Collectors.toList());
        List chatRooms = this.logicAutoReplyWechatMapper.queryByReplyIds(replyIds);
        Map wechatMap = chatRooms.stream().collect(Collectors.groupingBy(LogicAutoReplyWechat::getAutoReplyId, Collectors.mapping(a -> a.getWechatId(), Collectors.toList())));
        ArrayList allMessages = Lists.newArrayList();
        ArrayList<ReplyListResp> resps = new ArrayList<ReplyListResp>(replies.size());
        replies.forEach(reply -> {
            ReplyListResp resp = (ReplyListResp)BeanUtil.convert((Object)reply, ReplyListResp.class, (String[])new String[0]);
            resp.setId(reply.getId());
            resp.setEnabled(Integer.valueOf(reply.getEnabled() == null ? 0 : reply.getEnabled()));
            resp.setWechatIds((List)wechatMap.get(resp.getId()));
            List<AutoReplyMessageDto> messageDtos = this.replyMessageDtoService.parseAutoReplyMessageDtoList((LogicAutoReply)reply);
            resp.setReplyMessage(messageDtos);
            allMessages.addAll(messageDtos);
            resps.add(resp);
        });
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(allMessages);
        return resps;
    }

    private List<ReplyListResp> joinGroupReplyList(JoinGroupReplyListReqDto params) {
        log.info("query add friend reply list with params={}", (Object)params);
        JoinGroupListParams queryParams = (JoinGroupListParams)BeanUtil.convert((Object)params, JoinGroupListParams.class, (String[])new String[0]);
        int count = this.logicAutoReplyMapper.countJoinGroupListByParams(queryParams);
        queryParams.setCount(Integer.valueOf(count));
        if (count == 0) {
            return Collections.emptyList();
        }
        List replies = this.logicAutoReplyMapper.queryJoinGroupListByParams(queryParams);
        List replyIds = replies.stream().map(LogicAutoReply::getId).collect(Collectors.toList());
        List chatRooms = this.logicAutoReplyWechatRoomMapper.queryByReplyIds(replyIds);
        Map chatRoomMap = chatRooms.stream().collect(Collectors.groupingBy(LogicAutoReplyWechatRoom::getAutoReplyId, Collectors.mapping(it -> new RoomToRobotDto(it.getWechatRoomName(), it.getWechatId()), Collectors.toList())));
        ArrayList allMessages = Lists.newArrayList();
        ArrayList<ReplyListResp> resps = new ArrayList<ReplyListResp>(replies.size());
        replies.forEach(reply -> {
            ReplyListResp resp = (ReplyListResp)BeanUtil.convert((Object)reply, ReplyListResp.class, (String[])new String[0]);
            resp.setId(reply.getId());
            resp.setEnabled(Integer.valueOf(reply.getEnabled() == null ? 0 : reply.getEnabled()));
            resp.setChatRooms((List)chatRoomMap.get(resp.getId()));
            List<AutoReplyMessageDto> messageDtos = this.replyMessageDtoService.parseAutoReplyMessageDtoList((LogicAutoReply)reply);
            resp.setReplyMessage(messageDtos);
            allMessages.addAll(messageDtos);
            resps.add(resp);
        });
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(allMessages);
        return resps;
    }

    private void addOrModReplyWechat(@NonNull AddFriendReplyReqDto reqDto, @NonNull Long autoReplyId) {
        if (reqDto == null) {
            throw new NullPointerException("reqDto is marked @NonNull but is null");
        }
        if (autoReplyId == null) {
            throw new NullPointerException("autoReplyId is marked @NonNull but is null");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)reqDto.getWechatIds()), (Object)"\u5fae\u4fe1\u5fc5\u987b\u914d\u7f6e");
        this.logicAutoReplyWechatMapper.delByReplyId(autoReplyId, reqDto.getOperatorId(), Integer.valueOf(LogicWechatConfigType.ADD_FRIEND_REPLY.getValue()));
        ArrayList replyWechats = new ArrayList(reqDto.getWechatIds().size());
        reqDto.getWechatIds().forEach(wechatId -> {
            LogicAutoReplyWechat replyWechat = new LogicAutoReplyWechat();
            replyWechat.setAutoReplyId(autoReplyId);
            replyWechat.setWechatId(wechatId);
            replyWechat.setType(Integer.valueOf(LogicWechatConfigType.ADD_FRIEND_REPLY.getValue()));
            replyWechat.setCreateBy(reqDto.getOperatorId());
            replyWechat.setUpdateBy(reqDto.getOperatorId());
            replyWechats.add(replyWechat);
        });
        this.logicAutoReplyWechatMapper.batchInsert(replyWechats);
    }

    private void obsoleteLogicReply(JoinGroupReplyReqDto req, Long autoReplyId) {
        try {
            Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(req.getChatRooms());
            List logicAutoReplyWechatRoomList = this.logicAutoReplyWechatRoomMapper.selectObsoleteLogicAutoReplyRoom(autoReplyId, (List)Lists.newArrayList(chatRoomIds), req.getReplyType(), req.getRelationType(), req.getBusinessCustomerId());
            if (CollectionUtils.isNotEmpty((Collection)logicAutoReplyWechatRoomList)) {
                List logicAutoReplyWechatRoomIdList = logicAutoReplyWechatRoomList.stream().map(LogicAutoReplyWechatRoom::getAutoReplyId).distinct().collect(Collectors.toList());
                LinkedList roomIdDeleteList = Lists.newLinkedList();
                LinkedList replyIdDeleteList = Lists.newLinkedList();
                LogicAutoReplyWechatRoomCriteria logicAutoReplyWechatRoomCriteria2 = new LogicAutoReplyWechatRoomCriteria();
                logicAutoReplyWechatRoomCriteria2.createCriteria().andAutoReplyIdIn(logicAutoReplyWechatRoomIdList).andIsDeletedEqualTo(Boolean.valueOf(false));
                List logicAutoReplyWechatRoomList2 = this.logicAutoReplyWechatRoomMapper.selectByExample((Object)logicAutoReplyWechatRoomCriteria2);
                Map<Long, List<LogicAutoReplyWechatRoom>> logicAutoReplyWechatRoomMultiMap2 = logicAutoReplyWechatRoomList2.stream().collect(Collectors.groupingBy(LogicAutoReplyWechatRoom::getAutoReplyId));
                for (Map.Entry<Long, List<LogicAutoReplyWechatRoom>> entry2 : logicAutoReplyWechatRoomMultiMap2.entrySet()) {
                    List existWechatRoomNameList = entry2.getValue().stream().map(LogicAutoReplyWechatRoom::getWechatRoomName).distinct().collect(Collectors.toList());
                    Collection intersectionWechatRoomNameList = CollectionUtils.intersection(existWechatRoomNameList, chatRoomIds);
                    if (!CollectionUtils.isNotEmpty((Collection)intersectionWechatRoomNameList)) continue;
                    for (String intersectionWechatRoomName : intersectionWechatRoomNameList) {
                        entry2.getValue().forEach(_logicAutoReplyWechatRoom -> {
                            if (StringUtils.equals((CharSequence)intersectionWechatRoomName, (CharSequence)_logicAutoReplyWechatRoom.getWechatRoomName())) {
                                roomIdDeleteList.add(_logicAutoReplyWechatRoom.getId());
                            }
                        });
                    }
                    if (!CollectionUtils.containsAll(chatRoomIds, existWechatRoomNameList)) continue;
                    replyIdDeleteList.add(entry2.getKey());
                }
                if (CollectionUtils.isNotEmpty((Collection)roomIdDeleteList)) {
                    LogicAutoReplyWechatRoomCriteria logicAutoReplyWechatRoomCriteria3 = new LogicAutoReplyWechatRoomCriteria();
                    logicAutoReplyWechatRoomCriteria3.createCriteria().andIdIn((List)roomIdDeleteList).andIsDeletedEqualTo(Boolean.valueOf(false));
                    LogicAutoReplyWechatRoom logicAutoReplyWechatRoom = new LogicAutoReplyWechatRoom();
                    logicAutoReplyWechatRoom.setIsDeleted(Boolean.valueOf(true));
                    logicAutoReplyWechatRoom.setUpdateBy(req.getOperatorId());
                    logicAutoReplyWechatRoom.setUpdateTime(new Date());
                    this.logicAutoReplyWechatRoomMapper.updateByExampleSelective((Object)logicAutoReplyWechatRoom, (Object)logicAutoReplyWechatRoomCriteria3);
                }
                if (CollectionUtils.isNotEmpty((Collection)replyIdDeleteList)) {
                    LogicAutoReplyCriteria logicAutoReplyCriteria = new LogicAutoReplyCriteria();
                    logicAutoReplyCriteria.createCriteria().andIdIn((List)replyIdDeleteList).andIsDeletedEqualTo(Integer.valueOf(0));
                    LogicAutoReply logicAutoReply = new LogicAutoReply();
                    logicAutoReply.setIsDeleted(Integer.valueOf(1));
                    logicAutoReply.setUpdateBy(req.getOperatorId());
                    logicAutoReply.setUpdateTime(new Date());
                    this.logicAutoReplyMapper.updateByExampleSelective((Object)logicAutoReply, (Object)logicAutoReplyCriteria);
                }
            }
        }
        catch (Exception ex) {
            log.error("obsoleteLogicReply error", (Throwable)ex);
        }
    }

    public boolean checkReply(LogicReplyDto req) {
        log.info("check reply with req = {},operatorId = {}", (Object)req, (Object)req.getOperatorId());
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getReplyType() != null ? 1 : 0) != 0, (Object)"replyType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getRelationType() != null ? 1 : 0) != 0, (Object)"relationType\u4e0d\u80fd\u4e3a\u7a7a");
        if (req instanceof JoinGroupReplyReqDto) {
            JoinGroupReplyReqDto params = (JoinGroupReplyReqDto)req;
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getChatRooms()), (Object)"\u9009\u62e9\u7684\u7fa4\u4e0d\u53ef\u4e3a\u7a7a");
            Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(params.getChatRooms());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatRoomIds), (Object)"\u9009\u62e9\u7684\u7fa4\u4e0d\u53ef\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)this.commonReplyService.validateChatRoomIds(params.getChatRooms()), (Object)"\u9009\u62e9\u7684\u7fa4\u4e0d\u53ef\u91cd\u590d");
            List logicAutoReplyWechatRoomList = this.logicAutoReplyWechatRoomMapper.selectObsoleteLogicAutoReplyRoom(req.getId(), (List)Lists.newArrayList(chatRoomIds), req.getReplyType(), req.getRelationType(), req.getBusinessCustomerId());
            return CollectionUtils.isNotEmpty((Collection)logicAutoReplyWechatRoomList);
        }
        if (req instanceof AddFriendReplyReqDto) {
            List logicAutoReplyWechatList = this.logicAutoReplyWechatMapper.selectObsoleteLogicAutoWechatReply(req.getId(), (List)Lists.newArrayList((Iterable)((AddFriendReplyReqDto)req).getWechatIds()), req.getReplyType(), req.getRelationType(), req.getBusinessCustomerId());
            return CollectionUtils.isNotEmpty((Collection)logicAutoReplyWechatList);
        }
        return true;
    }

    private void obsoleteLogicWechatReply(AddFriendReplyReqDto req, Long autoReplyId) {
        try {
            log.info("obsoleteLogicWechatReply with autoReplyId={}, req={}", (Object)autoReplyId, (Object)req);
            Collection wechatIds = req.getWechatIds();
            List logicAutoReplyWechatList = this.logicAutoReplyWechatMapper.selectObsoleteLogicAutoWechatReply(autoReplyId, (List)Lists.newArrayList((Iterable)wechatIds), req.getReplyType(), req.getRelationType(), req.getBusinessCustomerId());
            log.info("logicAutoReplyWechatList={}", (Object)logicAutoReplyWechatList);
            if (CollectionUtils.isNotEmpty((Collection)logicAutoReplyWechatList)) {
                List ids = logicAutoReplyWechatList.stream().map(LogicAutoReplyWechat::getAutoReplyId).distinct().collect(Collectors.toList());
                LinkedList wechatIdDeleteList = Lists.newLinkedList();
                LinkedList replyIdDeleteList = Lists.newLinkedList();
                LogicAutoReplyWechatCriteria logicAutoReplyWechatCriteria2 = new LogicAutoReplyWechatCriteria();
                logicAutoReplyWechatCriteria2.createCriteria().andAutoReplyIdIn(ids).andIsDeletedEqualTo(Byte.valueOf((byte)0)).andTypeEqualTo(Integer.valueOf(LogicWechatConfigType.ADD_FRIEND_REPLY.getValue()));
                List logicAutoReplyWechatList2 = this.logicAutoReplyWechatMapper.selectByExample((Object)logicAutoReplyWechatCriteria2);
                Map<Long, List<LogicAutoReplyWechat>> logicAutoReplyWechatMultiMap2 = logicAutoReplyWechatList2.stream().collect(Collectors.groupingBy(LogicAutoReplyWechat::getAutoReplyId));
                for (Map.Entry<Long, List<LogicAutoReplyWechat>> entry2 : logicAutoReplyWechatMultiMap2.entrySet()) {
                    List existWechatIdList = entry2.getValue().stream().map(LogicAutoReplyWechat::getWechatId).distinct().collect(Collectors.toList());
                    Collection intersectionWechatList = CollectionUtils.intersection(existWechatIdList, (Iterable)wechatIds);
                    if (!CollectionUtils.isNotEmpty((Collection)intersectionWechatList)) continue;
                    for (String intersectionWechatId : intersectionWechatList) {
                        entry2.getValue().forEach(_logicAutoReplyWechat -> {
                            if (StringUtils.equals((CharSequence)intersectionWechatId, (CharSequence)_logicAutoReplyWechat.getWechatId())) {
                                wechatIdDeleteList.add(_logicAutoReplyWechat.getId());
                            }
                        });
                    }
                    if (!CollectionUtils.containsAll((Collection)wechatIds, existWechatIdList)) continue;
                    replyIdDeleteList.add(entry2.getKey());
                }
                if (CollectionUtils.isNotEmpty((Collection)wechatIdDeleteList)) {
                    LogicAutoReplyWechatCriteria logicAutoReplyWechatCriteria3 = new LogicAutoReplyWechatCriteria();
                    logicAutoReplyWechatCriteria3.createCriteria().andIdIn((List)wechatIdDeleteList).andIsDeletedEqualTo(Byte.valueOf((byte)0)).andTypeEqualTo(Integer.valueOf(LogicWechatConfigType.ADD_FRIEND_REPLY.getValue()));
                    LogicAutoReplyWechat logicAutoReplyWechat = new LogicAutoReplyWechat();
                    logicAutoReplyWechat.setIsDeleted(Byte.valueOf((byte)1));
                    logicAutoReplyWechat.setUpdateBy(req.getOperatorId());
                    logicAutoReplyWechat.setUpdateTime(new Date());
                    this.logicAutoReplyWechatMapper.updateByExampleSelective((Object)logicAutoReplyWechat, (Object)logicAutoReplyWechatCriteria3);
                }
                if (CollectionUtils.isNotEmpty((Collection)replyIdDeleteList)) {
                    LogicAutoReplyCriteria logicAutoReplyCriteria = new LogicAutoReplyCriteria();
                    logicAutoReplyCriteria.createCriteria().andIdIn((List)replyIdDeleteList).andIsDeletedEqualTo(Integer.valueOf(0));
                    LogicAutoReply logicAutoReply = new LogicAutoReply();
                    logicAutoReply.setIsDeleted(Integer.valueOf(1));
                    logicAutoReply.setUpdateTime(new Date());
                    logicAutoReply.setUpdateBy(req.getOperatorId());
                    this.logicAutoReplyMapper.updateByExampleSelective((Object)logicAutoReply, (Object)logicAutoReplyCriteria);
                }
            }
        }
        catch (Exception ex) {
            log.error("obsoleteLogicReply error", (Throwable)ex);
        }
    }

    public void enabled(ReplyEnabledReq reqDto) {
        this.commonReplyService.updateEnabled(reqDto);
    }

    public List<ReplyRoomWechatResp> queryReplyWechatRoom(List<String> roomIds) {
        log.info("queryReplyWechatRoom roomIds: {}", roomIds);
        if (CollectionUtils.isEmpty(roomIds)) {
            return Collections.emptyList();
        }
        List replyWechatRooms = this.logicAutoReplyWechatRoomMapper.queryListByChatroomIds(roomIds);
        ArrayList respList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)replyWechatRooms)) {
            replyWechatRooms.forEach(a -> {
                if (StringUtils.isNotEmpty((CharSequence)a.getWechatId())) {
                    ReplyRoomWechatResp resp = new ReplyRoomWechatResp();
                    resp.setRoomId(a.getWechatRoomName());
                    resp.setReplyWechatId(a.getReplyWechatId());
                    respList.add(resp);
                }
            });
        }
        return respList;
    }
}

