/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.service.cache.DrainageKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.FissionKeywordCacheService;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.CommonReplyService;
import com.kuaike.skynet.logic.service.reply.MarketKeywordReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.MarketWordReplyDto;
import com.kuaike.skynet.logic.service.reply.dto.req.BatchMarketWordReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.BatchMarketWordReplyRespDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketKeywordReplyServiceImpl
implements MarketKeywordReplyService {
    private static final Logger log = LoggerFactory.getLogger(MarketKeywordReplyServiceImpl.class);
    @Autowired
    private FissionKeywordCacheService fissionKeywordCacheService;
    @Autowired
    private DrainageKeywordCacheService drainageKeywordCacheService;
    @Autowired
    private CommonReplyService commonReplyService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;

    public BatchMarketWordReplyRespDto query(ReplyListReqDto params) {
        log.info("Query market keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        BatchMarketWordReplyRespDto respListDto = new BatchMarketWordReplyRespDto();
        LogicAutoReply larCondition = new LogicAutoReply();
        larCondition.setReplyType(params.getReplyType());
        larCondition.setRelationType(params.getRelationType());
        larCondition.setMarketPlanId(params.getMarketPlanId());
        List replyList = this.logicAutoReplyMapper.queryList(larCondition, params.getPageDto());
        if (params.getPageDto() != null) {
            PageDto pageDto = params.getPageDto();
            int count = this.logicAutoReplyMapper.countList(larCondition);
            pageDto.setCount(Integer.valueOf(count));
            if (CollectionUtils.isEmpty((Collection)replyList)) {
                pageDto.setCurPageCount(Integer.valueOf(0));
            } else {
                pageDto.setCurPageCount(Integer.valueOf(replyList.size()));
            }
            respListDto.setPageDto(pageDto);
        }
        if (CollectionUtils.isEmpty((Collection)replyList)) {
            respListDto.setList(Collections.emptyList());
            return respListDto;
        }
        List replyIds = replyList.stream().map(LogicAutoReply::getId).collect(Collectors.toList());
        List wordList = this.logicAutoReplyWordMapper.selectByAutoReplyIds(replyIds);
        Map<Long, List<LogicAutoReplyWord>> wordMap = wordList.stream().collect(Collectors.groupingBy(LogicAutoReplyWord::getAutoReplyId));
        ArrayList list = Lists.newArrayList();
        ArrayList replyMessageList = Lists.newArrayList();
        for (LogicAutoReply reply : replyList) {
            MarketWordReplyDto respDto = new MarketWordReplyDto();
            List<LogicAutoReplyWord> wordDtoList = wordMap.get(reply.getId());
            respDto.setWord(wordDtoList.get(0).getKeyWord());
            respDto.setType(wordDtoList.get(0).getType());
            respDto.setRequest(reply.getRequest());
            List<AutoReplyMessageDto> replyMessage = this.replyMessageDtoService.parseAutoReplyMessageDtoList(reply);
            respDto.setReplyMessage(replyMessage);
            list.add(respDto);
            replyMessageList.addAll(replyMessage);
        }
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(replyMessageList);
        respListDto.setList((List)list);
        return respListDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(BatchMarketWordReplyReqDto params) {
        log.info("Modify market keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params.getRelationType() != null ? 1 : 0) != 0, (Object)"\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getMarketPlanId() != null ? 1 : 0) != 0, (Object)"\u8425\u9500\u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        if (params.getList() == null) {
            params.setList((List)Lists.newArrayList());
        }
        ArrayList keyWords = Lists.newArrayList();
        params.getList().forEach(e -> {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getRequest()}), (Object)"\u95ee\u9898\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)e.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            AutoReplyWordDto wordDto = new AutoReplyWordDto(e.getWord(), e.getType());
            keyWords.add(wordDto);
        });
        this.validate(keyWords);
        this.batchDeleteReply(params);
        this.batchInsertReply(params);
        if (AutoReplyRelationType.FISSION_PLAN.getValue() == params.getRelationType().intValue()) {
            this.fissionKeywordCacheService.newVersion();
        } else if (AutoReplyRelationType.DRAINAGE_PLAN.getValue() == params.getRelationType().intValue()) {
            this.drainageKeywordCacheService.newVersion();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteAll(BatchMarketWordReplyReqDto params) {
        log.info("Modify market keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params.getRelationType() != null ? 1 : 0) != 0, (Object)"\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getMarketPlanId() != null ? 1 : 0) != 0, (Object)"\u8425\u9500\u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        this.batchDeleteReply(params);
    }

    private void validate(List<AutoReplyWordDto> keyWords) {
        HashSet exists = Sets.newHashSet();
        for (AutoReplyWordDto word : keyWords) {
            Preconditions.checkArgument((word.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{word.getWord()}), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
            if (word.getType().intValue() == KeywordMatchType.ACCURATE.getValue()) {
                Preconditions.checkArgument((boolean)exists.add(word.getWord()), (Object)"\u5173\u952e\u8bcd\u91cd\u590d");
                continue;
            }
            this.commonReplyService.validateFuzzyKeyword(word.getWord());
        }
    }

    private List<Long> batchDeleteReply(BatchMarketWordReplyReqDto params) {
        List<Object> replyIds = Lists.newArrayList();
        LogicAutoReply condition = new LogicAutoReply();
        condition.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        condition.setRelationType(params.getRelationType());
        condition.setMarketPlanId(params.getMarketPlanId());
        condition.setIsDeleted(Integer.valueOf(0));
        List logicAutoReplyList = this.logicAutoReplyMapper.select((Object)condition);
        if (CollectionUtils.isNotEmpty((Collection)logicAutoReplyList)) {
            replyIds = logicAutoReplyList.stream().map(LogicAutoReply::getId).collect(Collectors.toList());
            this.logicAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)replyIds, params.getOperatorId(), new Date());
            this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds((Collection)replyIds, params.getOperatorId(), new Date());
        }
        return replyIds;
    }

    private void batchInsertReply(BatchMarketWordReplyReqDto batchReq) {
        LogicAutoReply reply;
        if (batchReq.getList().size() == 0) {
            return;
        }
        Long operatorId = batchReq.getOperatorId();
        Long marketPlanId = batchReq.getMarketPlanId();
        Long merchantId = batchReq.getMerchantId();
        Long nodeId = batchReq.getNodeId();
        List replyDtoList = batchReq.getList();
        int replySize = replyDtoList.size();
        ArrayList replyList = Lists.newArrayList();
        for (MarketWordReplyDto dto : replyDtoList) {
            reply = new LogicAutoReply();
            String message = this.replyMessageDtoService.toReplyMessageStr(dto.getReplyMessage());
            String digest = SHA1Utils.digest((String)message);
            reply.setEnabled(Integer.valueOf(1));
            reply.setMessage(message);
            reply.setDigest(digest);
            reply.setRequest(dto.getRequest());
            reply.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
            reply.setRelationType(batchReq.getRelationType());
            reply.setMarketPlanId(marketPlanId);
            reply.setMerchantId(merchantId);
            reply.setNodeId(nodeId);
            reply.setCreateBy(operatorId);
            reply.setUpdateBy(operatorId);
            replyList.add(reply);
        }
        this.logicAutoReplyMapper.batchInsert((List)replyList);
        ArrayList wordList = Lists.newArrayList();
        for (int i = 0; i < replySize; ++i) {
            reply = (LogicAutoReply)replyList.get(i);
            MarketWordReplyDto wordDto = (MarketWordReplyDto)replyDtoList.get(i);
            LogicAutoReplyWord word = new LogicAutoReplyWord();
            word.setAutoReplyId(reply.getId());
            word.setKeyWord(wordDto.getWord());
            word.setType(wordDto.getType());
            word.setRequest("");
            word.setMessage("");
            word.setDigest("");
            word.setMerchantId(merchantId);
            word.setNodeId(nodeId);
            word.setCreateBy(operatorId);
            word.setUpdateBy(operatorId);
            wordList.add(word);
        }
        this.logicAutoReplyWordMapper.batchInsert((List)wordList);
    }
}

