/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.LogicReplyMsgDtoService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicReplyMsgDtoServiceImpl
implements LogicReplyMsgDtoService {
    private static final Logger log = LoggerFactory.getLogger(LogicReplyMsgDtoServiceImpl.class);
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;

    public List<AutoReplyMessageDto> fromCommonMessage(List<CommonMessage> list) {
        log.info("parse from common message list={}", list);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<AutoReplyMessageDto> result = this.replyMessageDtoService.parseAutoReplyMessageDtoList(new ReplyMessageDto(list));
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(result);
        return result;
    }

    public List<AutoReplyMessageDto> fillAutoReplyMessageDto(List<AutoReplyMessageDto> list) {
        log.info("fill auto reply message list={}", list);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(list);
        return list;
    }
}

