/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.skynet.logic.dal.reply.dto.ExistGroupKeywordDto;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatRoomMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.service.cache.GroupKeywordCacheService;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.CommonReplyService;
import com.kuaike.skynet.logic.service.reply.GroupKeywordReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.req.AutoReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.JoinGroupReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListRespDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.RoomToRobotDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupKeywordReplyServiceImpl
implements GroupKeywordReplyService {
    private static final Logger log = LoggerFactory.getLogger(GroupKeywordReplyServiceImpl.class);
    @Autowired
    private GroupKeywordCacheService groupKeywordCacheService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private CommonReplyService commonReplyService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyWechatRoomMapper logicAutoReplyWechatRoomMapper;

    private void validate(AutoReplyReqDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getRequest()), (Object)"\u95ee\u9898\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getChatRooms()), (Object)"\u6240\u9009\u7fa4\u4e0d\u80fd\u4e3a\u7a7a");
        Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(params.getChatRooms());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatRoomIds), (Object)"\u6240\u9009\u7fa4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)this.commonReplyService.validateChatRoomIds(params.getChatRooms()), (Object)"\u6240\u9009\u7fa4\u4e0d\u53ef\u91cd\u590d");
        AutoReplyWordDto wordDto = params.getKeyWord();
        Preconditions.checkArgument((wordDto != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((wordDto.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)wordDto.getWord()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        if (wordDto.getType().intValue() == KeywordMatchType.FUZZY.getValue()) {
            this.commonReplyService.validateFuzzyKeyword(wordDto.getWord());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(AutoReplyReqDto params) {
        log.info("Add group keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        this.validate(params);
        LogicAutoReply reply = this.newLogicAutoReply(params);
        reply.setNodeId(params.getNodeId());
        reply.setMerchantId(params.getBusinessCustomerId());
        reply.setCreateBy(params.getOperatorId());
        this.logicAutoReplyMapper.insertSelective((Object)reply);
        params.setId(reply.getId());
        this.commonReplyService.addOrModReplyChatRoom(params.getChatRooms(), reply.getId(), params.getOperatorId(), null);
        this.insertKeyword(params);
        this.clear(params);
        this.groupKeywordCacheService.newVersion();
    }

    @Transactional(rollbackFor={Exception.class})
    public void addAll(List<AutoReplyReqDto> list) {
        log.info("Add all auto reply list with list={}", list);
        Preconditions.checkArgument((list != null ? 1 : 0) != 0, (Object)"list\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            for (AutoReplyReqDto req : list) {
                this.add(req);
            }
        }
        catch (Exception ex) {
            log.error("add reply list failed.", (Throwable)ex);
            throw ex;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(AutoReplyReqDto params) {
        log.info("Modify group keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        this.validate(params);
        LogicAutoReply reply = this.newLogicAutoReply(params);
        reply.setId(params.getId());
        this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        this.commonReplyService.addOrModReplyChatRoom(params.getChatRooms(), params.getId(), params.getOperatorId(), null);
        this.insertKeyword(params);
        this.clear(params);
        this.groupKeywordCacheService.newVersion();
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(ReplyIdReqDto params) {
        log.info("Delete group keyword reply with params={}, operatorId={}", (Object)params, (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u56de\u590did\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> autoReplyIds = Collections.singletonList(params.getId());
        Long operatorId = params.getOperatorId();
        Date updateTime = new Date();
        this.logicAutoReplyMapper.logicDeleteByPrimaryKeys(autoReplyIds, operatorId, updateTime);
        this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds(autoReplyIds, operatorId, updateTime);
        this.logicAutoReplyWechatRoomMapper.logicDeleteByAutoReplyIds(autoReplyIds, operatorId, updateTime);
        this.groupKeywordCacheService.newVersion();
    }

    public boolean check(AutoReplyReqDto params) {
        log.info("Check group keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(params.getChatRooms());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatRoomIds), (Object)"\u6240\u9009\u7fa4\u4e0d\u80fd\u4e3a\u7a7a");
        AutoReplyWordDto wordDto = params.getKeyWord();
        Preconditions.checkArgument((wordDto != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((wordDto.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)wordDto.getWord()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        if (wordDto.getType().intValue() == KeywordMatchType.FUZZY.getValue()) {
            this.commonReplyService.validateFuzzyKeyword(wordDto.getWord());
            return false;
        }
        ArrayList relationTypes = Lists.newArrayList((Object[])new Integer[]{AutoReplyRelationType.CHAT_ROOM_GROUP.getValue(), AutoReplyRelationType.CHAT_ROOM.getValue()});
        Long replyId = params.getId();
        List existKeywords = this.logicAutoReplyWechatRoomMapper.queryExistGroupKeywords(wordDto.getWord(), chatRoomIds, replyId, Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()), (Collection)relationTypes, params.getBusinessCustomerId());
        return CollectionUtils.isNotEmpty((Collection)existKeywords);
    }

    public ReplyListResp detail(ReplyIdReqDto params) {
        log.info("Query group keyword reply detail with params={}, operatorId={}", (Object)params, (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        LogicAutoReply existReply = (LogicAutoReply)this.logicAutoReplyMapper.selectByPrimaryKey((Object)params.getId());
        List chatRoomList = this.logicAutoReplyWechatRoomMapper.queryByReplyIds(Collections.singletonList(existReply.getId()));
        List chatRooms = chatRoomList.stream().map(it -> new RoomToRobotDto(it.getWechatRoomName(), it.getWechatId())).collect(Collectors.toList());
        List<AutoReplyMessageDto> messageDtos = this.replyMessageDtoService.toAutoReplyMessageDtoList(existReply);
        LogicAutoReplyWord condition = new LogicAutoReplyWord();
        condition.setAutoReplyId(params.getId());
        condition.setIsDeleted(Boolean.valueOf(false));
        List logicAutoReplyWordList = this.logicAutoReplyWordMapper.select((Object)condition);
        AutoReplyWordDto keyWord = null;
        if (CollectionUtils.isNotEmpty((Collection)logicAutoReplyWordList)) {
            LogicAutoReplyWord logicAutoReplyWord = (LogicAutoReplyWord)logicAutoReplyWordList.get(0);
            keyWord = new AutoReplyWordDto(logicAutoReplyWord.getKeyWord(), logicAutoReplyWord.getType());
        }
        ReplyListResp resp = (ReplyListResp)BeanUtil.convert((Object)existReply, ReplyListResp.class, (String[])new String[0]);
        resp.setEnabled(Integer.valueOf(existReply.getEnabled() == null ? 0 : existReply.getEnabled()));
        resp.setChatRooms(chatRooms);
        resp.setReplyMessage(messageDtos);
        resp.setKeyWord(keyWord);
        return resp;
    }

    public ReplyListRespDto list(JoinGroupReplyListReqDto params) {
        return this.commonReplyService.list(params);
    }

    private LogicAutoReply newLogicAutoReply(AutoReplyReqDto params) {
        LogicAutoReply reply = new LogicAutoReply();
        reply.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        reply.setRelationType(Integer.valueOf(AutoReplyRelationType.CHAT_ROOM.getValue()));
        reply.setRequest(params.getRequest());
        String message = this.replyMessageDtoService.toReplyMessageStr(params.getReplyMessage());
        reply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        reply.setDigest(digest);
        reply.setUpdateBy(params.getOperatorId());
        reply.setUpdateTime(new Date());
        return reply;
    }

    private LogicAutoReplyWord newLogicAutoReplyWord(AutoReplyReqDto replyDto) {
        LogicAutoReplyWord word = new LogicAutoReplyWord();
        AutoReplyWordDto wordDto = replyDto.getKeyWord();
        word.setType(wordDto.getType());
        word.setKeyWord(wordDto.getWord());
        word.setAutoReplyId(replyDto.getId());
        word.setMerchantId(replyDto.getBusinessCustomerId());
        word.setNodeId(replyDto.getNodeId());
        word.setCreateBy(replyDto.getOperatorId());
        word.setUpdateBy(replyDto.getOperatorId());
        return word;
    }

    private void insertKeyword(AutoReplyReqDto params) {
        LogicAutoReplyWord word = this.newLogicAutoReplyWord(params);
        this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds(Collections.singleton(params.getId()), params.getOperatorId(), new Date());
        this.logicAutoReplyWordMapper.insertSelective((Object)word);
    }

    private void clear(AutoReplyReqDto req) {
        Set<String> chatroomIds = this.commonReplyService.getChatRoomIds(req.getChatRooms());
        Long operatorId = req.getOperatorId();
        Long merchantId = req.getBusinessCustomerId();
        Long replyId = req.getId();
        ArrayList relationTypes = Lists.newArrayList((Object[])new Integer[]{AutoReplyRelationType.CHAT_ROOM_GROUP.getValue(), AutoReplyRelationType.CHAT_ROOM.getValue()});
        AutoReplyWordDto keyword = req.getKeyWord();
        if (keyword.getType().intValue() != KeywordMatchType.ACCURATE.getValue()) {
            return;
        }
        List existKeywords = this.logicAutoReplyWechatRoomMapper.queryExistGroupKeywords(keyword.getWord(), chatroomIds, replyId, Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()), (Collection)relationTypes, merchantId);
        if (CollectionUtils.isEmpty((Collection)existKeywords)) {
            return;
        }
        this.clear(existKeywords, operatorId);
    }

    private void clear(List<ExistGroupKeywordDto> existKeywords, Long operatorId) {
        Date now = new Date();
        Set existRoomIds = existKeywords.stream().map(it -> it.getAutoReplyRoomId()).collect(Collectors.toSet());
        this.logicAutoReplyWechatRoomMapper.logicDeleteByPrimaryKeys(existRoomIds, operatorId, now);
        Set existReplyIds = existKeywords.stream().map(it -> it.getAutoReplyId()).collect(Collectors.toSet());
        Map existRoomCountMap = this.logicAutoReplyWechatRoomMapper.queryExistChatRoomCount(existReplyIds);
        HashSet toDel = Sets.newHashSet();
        for (Long id : existReplyIds) {
            Integer count = existRoomCountMap.getOrDefault(id, 0);
            if (count != 0) continue;
            toDel.add(id);
        }
        if (CollectionUtils.isNotEmpty((Collection)toDel)) {
            this.logicAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)toDel, operatorId, now);
            this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds((Collection)toDel, operatorId, now);
        }
    }
}

