/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.logic.dal.reply.dto.ExistFriendKeywordDto;
import com.kuaike.skynet.logic.dal.reply.dto.FriendKeywordListParams;
import com.kuaike.skynet.logic.dal.reply.dto.LogicAutoReplyWechatNickNameDto;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechat;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.enums.LogicWechatConfigType;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.dal.user.entity.User;
import com.kuaike.skynet.logic.dal.user.mapper.UserMapper;
import com.kuaike.skynet.logic.service.cache.FriendKeywordCacheService;
import com.kuaike.skynet.logic.service.common.dto.resp.OperatorResp;
import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.CommonReplyService;
import com.kuaike.skynet.logic.service.reply.FriendDefaultReplyService;
import com.kuaike.skynet.logic.service.reply.FriendKeywordReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyCheckReq;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyListReq;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyReq;
import com.kuaike.skynet.logic.service.reply.dto.resp.FriendKeywordReplyDetailResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.FriendKeywordReplyListResp;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FriendKeywordReplyServiceImpl
implements FriendKeywordReplyService {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordReplyServiceImpl.class);
    @Autowired
    private FriendKeywordCacheService friendKeywordCacheService;
    @Autowired
    private CommonReplyService commonReplyService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyWechatMapper logicAutoReplyWechatMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private FriendDefaultReplyService friendDefaultReplyService;

    @Transactional(rollbackFor={Exception.class})
    public Long add(FriendKeywordReplyReq params) {
        List<ExistFriendKeywordDto> existKeywords;
        log.info("add friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        if (params.getRtype().intValue() != FriendMsgReplyType.KEYWORD.getValue()) {
            return this.friendDefaultReplyService.add(params);
        }
        this.validate(params);
        params.setRelationType(Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()));
        params.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        LogicAutoReply reply = this.newLogicAutoReply(params);
        reply.setCreateBy(params.getOperatorId());
        reply.setUpdateBy(params.getOperatorId());
        reply.setNodeId(params.getNodeId());
        reply.setMerchantId(params.getBusinessCustomerId());
        this.logicAutoReplyMapper.insertSelective((Object)reply);
        params.setId(reply.getId());
        List<LogicAutoReplyWechat> wechatList = this.newLogicReplyWechatList(params);
        this.logicAutoReplyWechatMapper.batchInsert(wechatList);
        LogicAutoReplyWord word = this.newLogicReplyKeyword(params);
        word.setCreateBy(params.getOperatorId());
        word.setMerchantId(params.getBusinessCustomerId());
        word.setNodeId(params.getNodeId());
        this.logicAutoReplyWordMapper.insertSelective((Object)word);
        if (word.getType().intValue() == KeywordMatchType.ACCURATE.getValue() && CollectionUtils.isNotEmpty(existKeywords = this.queryExistKeywords(params.getKeyWord().getWord(), params.getWechatIds(), reply, params.getOperatorId()))) {
            this.clear(existKeywords, params.getOperatorId());
        }
        this.friendKeywordCacheService.newVersion();
        return params.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void addAll(List<FriendKeywordReplyReq> list) {
        log.info("add all friend keyword reply with list={}", list);
        if (CollectionUtils.isEmpty(list)) {
            log.warn("friend keyword reply list is empty.");
            return;
        }
        for (FriendKeywordReplyReq params : list) {
            this.add(params);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(FriendKeywordReplyReq params) {
        List<ExistFriendKeywordDto> existKeywords;
        log.info("modify friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        if (params.getRtype().intValue() != FriendMsgReplyType.KEYWORD.getValue()) {
            this.friendDefaultReplyService.modify(params);
            return;
        }
        this.validate(params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        params.setRelationType(Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()));
        params.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        List<Long> ids = Collections.singletonList(params.getId());
        Long updateBy = params.getOperatorId();
        Date updateTime = new Date();
        LogicAutoReply reply = this.newLogicAutoReply(params);
        reply.setId(params.getId());
        reply.setUpdateBy(updateBy);
        reply.setUpdateTime(updateTime);
        reply.setCreateBy(null);
        reply.setNodeId(null);
        reply.setMerchantId(null);
        this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        List<LogicAutoReplyWechat> wechatList = this.newLogicReplyWechatList(params);
        this.logicAutoReplyWechatMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
        this.logicAutoReplyWechatMapper.batchInsert(wechatList);
        LogicAutoReplyWord word = this.logicAutoReplyWordMapper.selectByAutoReplyId(params.getId());
        AutoReplyWordDto keyword = params.getKeyWord();
        word.setKeyWord(keyword.getWord());
        word.setType(keyword.getType());
        word.setUpdateBy(updateBy);
        word.setUpdateTime(updateTime);
        this.logicAutoReplyWordMapper.updateByPrimaryKeySelective((Object)word);
        if (word.getType().intValue() == KeywordMatchType.ACCURATE.getValue() && CollectionUtils.isNotEmpty(existKeywords = this.queryExistKeywords(keyword.getWord(), params.getWechatIds(), reply, updateBy))) {
            this.clear(existKeywords, params.getOperatorId());
        }
        this.friendKeywordCacheService.newVersion();
    }

    public List<String> check(FriendKeywordReplyCheckReq params) {
        log.info("check friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"rtype is null");
        if (params.getRtype().intValue() != FriendMsgReplyType.KEYWORD.getValue()) {
            return this.friendDefaultReplyService.check(params);
        }
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u7c7b\u578b\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)params.getKeyword())) {
            log.info("\u5173\u952e\u8bcd\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u68c0\u6d4b");
            return null;
        }
        if (params.getType().intValue() == KeywordMatchType.FUZZY.getValue()) {
            this.commonReplyService.validateFuzzyKeyword(params.getKeyword());
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)params.getWechatIds())) {
            log.info("\u5fae\u4fe1\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u68c0\u6d4b");
            return null;
        }
        Long replyId = params.getId();
        List existKeywords = this.logicAutoReplyWechatMapper.queryExistFriendKeywords(params.getKeyword(), params.getWechatIds(), replyId, Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()), params.getBusinessCustomerId());
        if (CollectionUtils.isEmpty((Collection)existKeywords)) {
            return null;
        }
        List<String> wechatIds = existKeywords.stream().map(it -> it.getWechatId()).collect(Collectors.toList());
        return wechatIds;
    }

    public FriendKeywordReplyListResp list(FriendKeywordReplyListReq params) {
        log.info("query friend keyword reply list with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u53ef\u4e3a\u7a7a");
        Sets.SetView keywordFiltedIds = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getKeywordQuery()})) {
            List autoReplyIds = this.logicAutoReplyWordMapper.fuzzyQueryAutoReplyIds(params.getKeywordQuery());
            if (CollectionUtils.isNotEmpty((Collection)autoReplyIds)) {
                keywordFiltedIds = new HashSet();
                keywordFiltedIds.addAll(autoReplyIds);
                log.info("Filted by keyword={}, autoReplyIds={}", (Object)params.getKeywordQuery(), (Object)keywordFiltedIds);
            } else {
                log.info("\u627e\u4e0d\u5230\u5339\u914d\u7684\u5173\u952e\u8bcd\uff0c\u7b5b\u9009\u7ed3\u679c\u4e3a\u7a7a. keywordQuery={}", (Object)params.getKeywordQuery());
                return this.emptyFriendKeywordReplyListResp();
            }
        }
        Set wechatFiltedIds = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getWechatId()})) {
            List list = this.logicAutoReplyWechatMapper.queryByWechatName(params.getWechatId());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                wechatFiltedIds = list.stream().map(it -> it.getAutoReplyId()).collect(Collectors.toSet());
                log.info("Filted by wechatId={}, autoReplyIds={}", (Object)params.getWechatId(), wechatFiltedIds);
            } else {
                log.info("\u627e\u4e0d\u5230\u5339\u914d\u7684\u5fae\u4fe1\u53f7\uff0c\u7b5b\u9009\u7ed3\u679c\u4e3a\u7a7a. wechatId={}", (Object)params.getWechatId());
                return this.emptyFriendKeywordReplyListResp();
            }
        }
        Sets.SetView ids = null;
        if (keywordFiltedIds != null && wechatFiltedIds != null) {
            ids = Sets.intersection(keywordFiltedIds, wechatFiltedIds);
            log.info("Use keyword and wechatId filter, ids={}", (Object)ids);
            if (CollectionUtils.isEmpty((Collection)ids)) {
                log.info("Ids is empty.");
                return this.emptyFriendKeywordReplyListResp();
            }
        } else if (keywordFiltedIds != null) {
            ids = keywordFiltedIds;
            log.info("Use keyword filter, ids={}", (Object)ids);
        } else if (wechatFiltedIds != null) {
            ids = wechatFiltedIds;
            log.info("Use wechatId filter, ids={}", (Object)ids);
        }
        List<Long> userIds = null;
        if (params.getUserId() != null) {
            userIds = Collections.singletonList(params.getUserId());
        }
        FriendKeywordListParams queryParam = new FriendKeywordListParams();
        queryParam.setMerchantId(params.getBusinessCustomerId());
        queryParam.setOperatorId(params.getOperatorId());
        queryParam.setNodeIds(params.getNodeIds());
        queryParam.setRelationType(Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()));
        if (params.getRtype() == null) {
            queryParam.setReplyTypes((Collection)Lists.newArrayList((Object[])new Integer[]{AutoReplyType.KEY_WORD_REPLY.getValue(), AutoReplyType.DEFAULT_REPLY.getValue()}));
        } else {
            FriendMsgReplyType rType = FriendMsgReplyType.getType((Integer)params.getRtype());
            Preconditions.checkArgument((rType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
            switch (rType) {
                case KEYWORD: {
                    queryParam.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
                    break;
                }
                case DEFAULT: 
                case IMAGE: 
                case VIDEO: 
                case VOICE: 
                case FILE: {
                    queryParam.setReplyType(Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()));
                    queryParam.setDefaultMsgType(rType.getDesc());
                }
            }
        }
        queryParam.setIds((Collection)ids);
        queryParam.setUserIds(userIds);
        queryParam.setUpdateStartTime(params.getUpdateStartTime());
        queryParam.setUpdateEndTime(params.getUpdateEndTime());
        queryParam.setPageDto(params.getPageDto());
        queryParam.setTimeSort(params.getTimeSort());
        int count = this.logicAutoReplyMapper.countFriendKeywordReply(queryParam);
        if (count <= 0) {
            log.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
            return this.emptyFriendKeywordReplyListResp();
        }
        List list = this.logicAutoReplyMapper.queryFriendKeywordReply(queryParam);
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        FriendKeywordReplyListResp resp = new FriendKeywordReplyListResp();
        resp.setList(this.toRespList(list));
        resp.setPageDto(params.getPageDto());
        return resp;
    }

    public FriendKeywordReplyDetailResp detail(FriendKeywordReplyIdReqDto params) {
        log.info("query friend keyword reply detail with params={}", (Object)params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Long id = params.getId();
        LogicAutoReply reply = (LogicAutoReply)this.logicAutoReplyMapper.selectByPrimaryKey((Object)id);
        if (reply == null) {
            log.warn("\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, id={}", (Object)id);
            return null;
        }
        LogicAutoReplyWord word = this.logicAutoReplyWordMapper.selectByAutoReplyId(id);
        List wechats = this.logicAutoReplyWechatMapper.queryByReplyIds(Collections.singletonList(id));
        User user = (User)this.userMapper.selectByPrimaryKey((Object)reply.getUpdateBy());
        List<AutoReplyMessageDto> replyMessage = this.replyMessageDtoService.toAutoReplyMessageDtoList(reply);
        FriendKeywordReplyDetailResp result = this.toDetailResp(reply, word, wechats, user);
        result.setReplyMessage(replyMessage);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(FriendKeywordReplyIdReqDto params) {
        log.info("delete friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        List<Long> ids = Collections.singletonList(params.getId());
        Long updateBy = params.getOperatorId();
        Date updateTime = new Date();
        try {
            this.logicAutoReplyMapper.logicDeleteByPrimaryKeys(ids, updateBy, updateTime);
            this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
            this.logicAutoReplyWechatMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
        }
        catch (Exception e) {
            log.error("Failed deleting friend keyword reply with params={}", (Object)params, (Object)e);
            throw e;
        }
        this.friendKeywordCacheService.newVersion();
    }

    private void validate(FriendKeywordReplyReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getWechatIds()), (Object)"wechatIds\u4e0d\u80fd\u4e3a\u7a7a");
        for (String wechatId : params.getWechatIds()) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wechatId}), (Object)"wechatId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AutoReplyWordDto wordDto = params.getKeyWord();
        Preconditions.checkArgument((wordDto != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((wordDto.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wordDto.getWord()}), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        if (params.getKeyWord().getType().intValue() == KeywordMatchType.FUZZY.getValue()) {
            this.commonReplyService.validateFuzzyKeyword(wordDto.getWord());
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getRequest()), (Object)"\u95ee\u9898\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private LogicAutoReply newLogicAutoReply(FriendKeywordReplyReq params) {
        LogicAutoReply logicAutoReply = new LogicAutoReply();
        logicAutoReply.setReplyType(params.getReplyType());
        logicAutoReply.setRelationType(params.getRelationType());
        logicAutoReply.setRequest(params.getRequest());
        String message = this.replyMessageDtoService.toReplyMessageStr(params.getReplyMessage());
        logicAutoReply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        logicAutoReply.setDigest(digest);
        return logicAutoReply;
    }

    private List<LogicAutoReplyWechat> newLogicReplyWechatList(@NonNull FriendKeywordReplyReq params) {
        if (params == null) {
            throw new NullPointerException("params is marked @NonNull but is null");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getWechatIds()), (Object)"\u5fae\u4fe1\u5fc5\u987b\u914d\u7f6e");
        Long autoReplyId = params.getId();
        List wechatIds = params.getWechatIds();
        Long operatorId = params.getOperatorId();
        ArrayList<LogicAutoReplyWechat> list = new ArrayList<LogicAutoReplyWechat>(wechatIds.size());
        for (String wechatId : wechatIds) {
            LogicAutoReplyWechat replyWechat = new LogicAutoReplyWechat();
            replyWechat.setAutoReplyId(autoReplyId);
            replyWechat.setWechatId(wechatId);
            replyWechat.setCreateBy(operatorId);
            replyWechat.setUpdateBy(operatorId);
            replyWechat.setType(Integer.valueOf(LogicWechatConfigType.KEYWORD_REPLY.getValue()));
            list.add(replyWechat);
        }
        return list;
    }

    private LogicAutoReplyWord newLogicReplyKeyword(FriendKeywordReplyReq params) {
        AutoReplyWordDto word = params.getKeyWord();
        LogicAutoReplyWord record = new LogicAutoReplyWord();
        record.setKeyWord(word.getWord());
        record.setType(word.getType());
        record.setAutoReplyId(params.getId());
        record.setUpdateBy(params.getOperatorId());
        return record;
    }

    private List<ExistFriendKeywordDto> queryExistKeywords(String keyword, List<String> wechatIds, LogicAutoReply reply, Long operatorId) {
        List existKeywords = this.logicAutoReplyWechatMapper.queryExistFriendKeywords(keyword, wechatIds, reply.getId(), Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()), reply.getMerchantId());
        if (CollectionUtils.isEmpty((Collection)existKeywords)) {
            log.info("\u6ca1\u6709\u91cd\u590d\u7684\u5173\u952e\u8bcd\uff0c\u65e0\u9700\u53bb\u91cd\u3002");
            return Collections.emptyList();
        }
        return existKeywords;
    }

    private void clear(List<ExistFriendKeywordDto> existKeywords, Long updateBy) {
        Date updateTime = new Date();
        Set existWechatIds = existKeywords.stream().map(it -> it.getAutoReplyWechatId()).collect(Collectors.toSet());
        this.logicAutoReplyWechatMapper.logicDeleteByPrimaryKeys(existWechatIds, updateBy, updateTime);
        Set existReplyIds = existKeywords.stream().map(it -> it.getAutoReplyId()).collect(Collectors.toSet());
        Map existWechatCountMap = this.logicAutoReplyWechatMapper.queryExistWechatCount(existReplyIds);
        HashSet toDel = Sets.newHashSet();
        for (Long replyId : existReplyIds) {
            Integer count = existWechatCountMap.getOrDefault(replyId, 0);
            if (count != 0) continue;
            toDel.add(replyId);
        }
        if (CollectionUtils.isNotEmpty((Collection)toDel)) {
            this.logicAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)toDel, updateBy, updateTime);
            this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds((Collection)toDel, updateBy, updateTime);
        }
    }

    private FriendKeywordReplyListResp emptyFriendKeywordReplyListResp() {
        FriendKeywordReplyListResp resp = new FriendKeywordReplyListResp();
        resp.setList(Collections.emptyList());
        resp.setPageDto(new PageDto());
        return resp;
    }

    private FriendKeywordReplyDetailResp toDetailResp(LogicAutoReply reply, LogicAutoReplyWord word, List<LogicAutoReplyWechatNickNameDto> wechats, User user) {
        String request = reply.getRequest();
        AutoReplyWordDto keyword = null;
        if (word != null) {
            keyword = new AutoReplyWordDto();
            keyword.setWord(word.getKeyWord());
            keyword.setType(word.getType());
        }
        ArrayList wechatList = null;
        if (CollectionUtils.isNotEmpty(wechats)) {
            wechatList = Lists.newArrayList();
            for (LogicAutoReplyWechatNickNameDto replyWechat : wechats) {
                String wechatId = replyWechat.getWechatId();
                WechatResp w = new WechatResp();
                w.setId(wechatId);
                w.setAlias(replyWechat.getWechatAlias());
                w.setNickname(replyWechat.getWechatNickName());
                wechatList.add(w);
            }
        }
        OperatorResp updator = null;
        if (user != null) {
            updator = new OperatorResp();
            updator.setId(user.getId());
            updator.setOperateTime(reply.getUpdateTime());
            updator.setUsername(user.getName());
            updator.setNickname(user.getNickName());
        }
        FriendKeywordReplyDetailResp resp = new FriendKeywordReplyDetailResp();
        resp.setId(reply.getId());
        resp.setKeyWord(keyword);
        resp.setRequest(request);
        resp.setApplyScopeList((List)wechatList);
        resp.setUpdator(updator);
        if (reply.getReplyType().intValue() == AutoReplyType.KEY_WORD_REPLY.getValue()) {
            resp.setRtype(Integer.valueOf(FriendMsgReplyType.KEYWORD.getValue()));
        } else if (reply.getReplyType().intValue() == AutoReplyType.DEFAULT_REPLY.getValue()) {
            FriendMsgReplyType rType = FriendMsgReplyType.getType((String)reply.getRequest());
            if (rType != null) {
                resp.setRtype(Integer.valueOf(rType.getValue()));
                resp.setRequest("");
            } else {
                log.warn("Unknown wechat default reply type, id={}, request={}", (Object)reply.getId(), (Object)reply.getRequest());
            }
        }
        return resp;
    }

    private List<FriendKeywordReplyDetailResp> toRespList(List<LogicAutoReply> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List ids = list.stream().map(it -> it.getId()).collect(Collectors.toList());
        List replyWordList = this.logicAutoReplyWordMapper.selectByAutoReplyIds(ids);
        Map<Long, List<LogicAutoReplyWord>> replyWordMap = replyWordList.stream().collect(Collectors.groupingBy(it -> it.getAutoReplyId()));
        List replyWechatList = this.logicAutoReplyWechatMapper.queryByReplyIds(ids);
        Map<Long, List<LogicAutoReplyWechatNickNameDto>> replyWechatMap = replyWechatList.stream().collect(Collectors.groupingBy(it -> it.getAutoReplyId()));
        List userIds = list.stream().map(it -> it.getUpdateBy()).collect(Collectors.toList());
        List userList = this.userMapper.selectByIds(userIds);
        Map<Long, User> userMap = userList.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        ArrayList allMessages = Lists.newArrayList();
        for (LogicAutoReply reply : list) {
            LogicAutoReplyWord word = null;
            List<LogicAutoReplyWord> wordList = replyWordMap.get(reply.getId());
            if (wordList != null && wordList.size() > 0) {
                word = wordList.get(0);
            }
            List<LogicAutoReplyWechatNickNameDto> wechats = replyWechatMap.get(reply.getId());
            User user = userMap.get(reply.getUpdateBy());
            List<AutoReplyMessageDto> replyMessage = this.replyMessageDtoService.parseAutoReplyMessageDtoList(reply);
            allMessages.addAll(replyMessage);
            FriendKeywordReplyDetailResp resp = this.toDetailResp(reply, word, wechats, user);
            resp.setReplyMessage(replyMessage);
            result.add(resp);
        }
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(allMessages);
        return result;
    }
}

