/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechat;
import com.kuaike.skynet.logic.dal.reply.enums.LogicWechatConfigType;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatMapper;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.FriendDefaultReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyCheckReq;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyReq;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendDefaultReplyServiceImpl
implements FriendDefaultReplyService {
    private static final Logger log = LoggerFactory.getLogger(FriendDefaultReplyServiceImpl.class);
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWechatMapper logicAutoReplyWechatMapper;

    @Override
    public Long add(FriendKeywordReplyReq params) {
        log.info("Add friend default reply with params={}", (Object)params);
        this.validate(params);
        LogicAutoReply reply = new LogicAutoReply();
        reply.setRelationType(Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()));
        reply.setReplyType(Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()));
        String message = this.replyMessageDtoService.toReplyMessageStr(params.getReplyMessage());
        reply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        reply.setDigest(digest);
        FriendMsgReplyType rType = FriendMsgReplyType.getType((Integer)params.getRtype());
        reply.setRequest(rType.getDesc());
        reply.setCreateBy(params.getOperatorId());
        reply.setUpdateBy(params.getOperatorId());
        reply.setNodeId(params.getNodeId());
        reply.setMerchantId(params.getBusinessCustomerId());
        this.logicAutoReplyMapper.insertSelective((Object)reply);
        params.setId(reply.getId());
        List<LogicAutoReplyWechat> wechatList = this.newLogicReplyWechatList(params);
        this.logicAutoReplyWechatMapper.batchInsert(wechatList);
        List existWechatList = this.logicAutoReplyWechatMapper.queryExistFriendDefaultReply(rType.getDesc(), params.getWechatIds(), params.getId(), Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()), params.getBusinessCustomerId());
        if (CollectionUtils.isNotEmpty((Collection)existWechatList)) {
            this.clear(existWechatList, params.getOperatorId());
        }
        return params.getId();
    }

    @Override
    public void modify(FriendKeywordReplyReq params) {
        log.info("Modify friend default reply with params={}", (Object)params);
        this.validate(params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        params.setRelationType(Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()));
        params.setReplyType(Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()));
        Long updateBy = params.getOperatorId();
        Date updateTime = new Date();
        LogicAutoReply reply = new LogicAutoReply();
        reply.setId(params.getId());
        String message = this.replyMessageDtoService.toReplyMessageStr(params.getReplyMessage());
        reply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        reply.setDigest(digest);
        reply.setUpdateBy(updateBy);
        reply.setUpdateTime(updateTime);
        this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        List<LogicAutoReplyWechat> wechatList = this.newLogicReplyWechatList(params);
        List<Long> ids = Collections.singletonList(params.getId());
        this.logicAutoReplyWechatMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
        this.logicAutoReplyWechatMapper.batchInsert(wechatList);
        FriendMsgReplyType rType = FriendMsgReplyType.getType((Integer)params.getRtype());
        List existWechatList = this.logicAutoReplyWechatMapper.queryExistFriendDefaultReply(rType.getDesc(), params.getWechatIds(), params.getId(), Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()), params.getBusinessCustomerId());
        if (CollectionUtils.isNotEmpty((Collection)existWechatList)) {
            this.clear(existWechatList, params.getOperatorId());
        }
    }

    @Override
    public List<String> check(FriendKeywordReplyCheckReq params) {
        log.info("Check friend default reply with params={}", (Object)params);
        if (CollectionUtils.isEmpty((Collection)params.getWechatIds())) {
            log.info("\u5fae\u4fe1\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u68c0\u6d4b");
            return null;
        }
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        FriendMsgReplyType rType = FriendMsgReplyType.getType((Integer)params.getRtype());
        Preconditions.checkArgument((rType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        Preconditions.checkArgument((rType != FriendMsgReplyType.KEYWORD ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        List existWechatIds = this.logicAutoReplyWechatMapper.queryExistFriendDefaultReply(rType.getDesc(), params.getWechatIds(), params.getId(), Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()), params.getBusinessCustomerId());
        if (CollectionUtils.isEmpty((Collection)existWechatIds)) {
            return null;
        }
        List<String> wechatIds = existWechatIds.stream().map(it -> it.getWechatId()).collect(Collectors.toList());
        return wechatIds;
    }

    @Override
    public void validate(FriendKeywordReplyReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        FriendMsgReplyType rType = FriendMsgReplyType.getType((Integer)params.getRtype());
        Preconditions.checkArgument((rType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        Preconditions.checkArgument((rType != FriendMsgReplyType.KEYWORD ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getWechatIds()), (Object)"wechatIds\u4e0d\u80fd\u4e3a\u7a7a");
        for (String wechatId : params.getWechatIds()) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wechatId}), (Object)"wechatId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<LogicAutoReplyWechat> newLogicReplyWechatList(@NonNull FriendKeywordReplyReq params) {
        if (params == null) {
            throw new NullPointerException("params is marked @NonNull but is null");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getWechatIds()), (Object)"\u5fae\u4fe1\u5fc5\u987b\u914d\u7f6e");
        Long autoReplyId = params.getId();
        List wechatIds = params.getWechatIds();
        Long operatorId = params.getOperatorId();
        ArrayList<LogicAutoReplyWechat> list = new ArrayList<LogicAutoReplyWechat>(wechatIds.size());
        for (String wechatId : wechatIds) {
            LogicAutoReplyWechat replyWechat = new LogicAutoReplyWechat();
            replyWechat.setAutoReplyId(autoReplyId);
            replyWechat.setWechatId(wechatId);
            replyWechat.setCreateBy(operatorId);
            replyWechat.setUpdateBy(operatorId);
            replyWechat.setType(Integer.valueOf(LogicWechatConfigType.KEYWORD_REPLY.getValue()));
            list.add(replyWechat);
        }
        return list;
    }

    private void clear(List<LogicAutoReplyWechat> existWechatList, Long updateBy) {
        Date updateTime = new Date();
        Set existWechatIds = existWechatList.stream().map(it -> it.getId()).collect(Collectors.toSet());
        this.logicAutoReplyWechatMapper.logicDeleteByPrimaryKeys(existWechatIds, updateBy, updateTime);
        Set existReplyIds = existWechatList.stream().map(it -> it.getAutoReplyId()).collect(Collectors.toSet());
        Map existWechatCountMap = this.logicAutoReplyWechatMapper.queryExistWechatCount(existReplyIds);
        HashSet toDel = Sets.newHashSet();
        for (Long replyId : existReplyIds) {
            Integer count = existWechatCountMap.getOrDefault(replyId, 0);
            if (count != 0) continue;
            toDel.add(replyId);
        }
        if (CollectionUtils.isNotEmpty((Collection)toDel)) {
            this.logicAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)toDel, updateBy, updateTime);
        }
    }
}

