/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.skynet.logic.dal.reply.dto.JoinGroupListParams;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechatRoom;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatRoomMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.dal.user.entity.User;
import com.kuaike.skynet.logic.dal.user.mapper.UserMapper;
import com.kuaike.skynet.logic.service.reply.CommonReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.IdAndNameExtendDto;
import com.kuaike.skynet.logic.service.reply.dto.LogicReplyWechatDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;
import com.kuaike.skynet.logic.service.reply.dto.req.JoinGroupReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyEnabledReq;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListRespDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.RoomToRobotDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.util.KeywordUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonReplyServiceImpl
implements CommonReplyService {
    private static final Logger log = LoggerFactory.getLogger(CommonReplyServiceImpl.class);
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyWechatRoomMapper logicAutoReplyWechatRoomMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    public void updateEnabled(ReplyEnabledReq params) {
        log.info("update reply enabled with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"ID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getEnabled() != null ? 1 : 0) != 0, (Object)"enabled\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005\u4e3a\u7a7a");
        LogicAutoReply reply = new LogicAutoReply();
        reply.setId(params.getId());
        reply.setEnabled(Integer.valueOf(params.getEnabled() != 0 ? 1 : 0));
        reply.setUpdateBy(params.getOperatorId());
        reply.setUpdateTime(new Date());
        this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
    }

    @Override
    public boolean validateChatRoomIds(Collection<RobotToRoomDto> chatRooms) {
        if (CollectionUtils.isEmpty(chatRooms)) {
            return true;
        }
        HashSet chatRoomIds = Sets.newHashSet();
        for (RobotToRoomDto dto : chatRooms) {
            if (CollectionUtils.isEmpty((Collection)dto.getChatroomIds())) continue;
            for (String id : dto.getChatroomIds()) {
                if (StringUtils.isBlank((CharSequence)id)) continue;
                if (chatRoomIds.contains(id)) {
                    return false;
                }
                chatRoomIds.add(id);
            }
        }
        return true;
    }

    @Override
    public void validateFuzzyKeyword(String word) {
        KeywordUtil.validateFuzzyKeyword((String)word);
    }

    @Override
    public Set<String> getChatRoomIds(Collection<RobotToRoomDto> chatRooms) {
        if (CollectionUtils.isEmpty(chatRooms)) {
            return Collections.emptySet();
        }
        HashSet chatRoomIds = Sets.newHashSet();
        for (RobotToRoomDto dto : chatRooms) {
            chatRoomIds.addAll(dto.getChatroomIds());
            for (String id : dto.getChatroomIds()) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                chatRoomIds.add(id);
            }
        }
        return chatRoomIds;
    }

    @Override
    public void addOrModReplyChatRoom(@NonNull Collection<RobotToRoomDto> rooms, @NonNull Long autoReplyId, @NonNull Long operatorId, List<LogicReplyWechatDto> wechatDtos) {
        if (rooms == null) {
            throw new NullPointerException("rooms is marked @NonNull but is null");
        }
        if (autoReplyId == null) {
            throw new NullPointerException("autoReplyId is marked @NonNull but is null");
        }
        if (operatorId == null) {
            throw new NullPointerException("operatorId is marked @NonNull but is null");
        }
        log.info("save reply rooms, id={}, operatorId={}, chatRooms={}, wechatDtos: {}", new Object[]{autoReplyId, operatorId, rooms, wechatDtos});
        this.logicAutoReplyWechatRoomMapper.delByReplyId(autoReplyId, operatorId);
        ArrayList<LogicAutoReplyWechatRoom> list = new ArrayList<LogicAutoReplyWechatRoom>();
        for (RobotToRoomDto dto : rooms) {
            String wechatId = dto.getWechatId();
            log.info("addOrModReplyChatRoom  wechatId: {}", (Object)wechatId);
            for (String chatRoomId : dto.getChatroomIds()) {
                if (StringUtils.isBlank((CharSequence)chatRoomId)) {
                    log.warn("chatroomId is blank. dto={}", (Object)dto);
                    continue;
                }
                LogicAutoReplyWechatRoom replyChatRoom = new LogicAutoReplyWechatRoom();
                replyChatRoom.setAutoReplyId(autoReplyId);
                replyChatRoom.setWechatRoomName(chatRoomId);
                replyChatRoom.setWechatId(wechatId);
                replyChatRoom.setCreateBy(operatorId);
                replyChatRoom.setUpdateBy(operatorId);
                if (CollectionUtils.isNotEmpty(wechatDtos)) {
                    List filterDtos = wechatDtos.stream().filter(a -> a.getChatroomId().equals(chatRoomId)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(filterDtos)) {
                        LogicReplyWechatDto wechatDto = (LogicReplyWechatDto)filterDtos.get(0);
                        replyChatRoom.setReplyWechatId(wechatDto.getReplyWechatId());
                    }
                    log.info("addOrModReplyChatRoom new reply wechatId: {}, roomId: {}", (Object)replyChatRoom.getReplyWechatId(), (Object)replyChatRoom.getWechatRoomName());
                }
                list.add(replyChatRoom);
            }
        }
        this.logicAutoReplyWechatRoomMapper.batchInsert(list);
    }

    @Override
    public ReplyListRespDto list(JoinGroupReplyListReqDto params) {
        log.info("Query auto reply list with params={}, operatorId={}", (Object)params, (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getPageDto() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Stopwatch sw = Stopwatch.createStarted();
        List<ReplyListResp> replies = this.queryList(params);
        log.info("autoReply list:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        Stopwatch sw1 = Stopwatch.createStarted();
        Set userIds = replies.stream().flatMap(a -> Stream.of(a.getCreateBy(), a.getUpdateBy())).collect(Collectors.toSet());
        List users = this.userMapper.selectByIds(userIds);
        Map userMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        replies.forEach(reply -> {
            User create = (User)userMap.get(reply.getCreateBy());
            IdAndNameExtendDto creator = new IdAndNameExtendDto();
            creator.setId(reply.getCreateBy());
            creator.setName(create != null ? create.getName() : "");
            creator.setNickName(create != null ? create.getNickName() : "");
            reply.setCreator(creator);
            User updateBy = (User)userMap.get(reply.getUpdateBy());
            IdAndNameExtendDto updator = new IdAndNameExtendDto();
            updator.setId(reply.getUpdateBy());
            updator.setName(updateBy != null ? updateBy.getName() : "");
            updator.setNickName(updateBy != null ? updateBy.getNickName() : "");
            reply.setUpdator(updator);
        });
        log.info("autoReply list1:{}", (Object)sw1.elapsed(TimeUnit.MILLISECONDS));
        return this.getListRespDto(replies, params.getPageDto());
    }

    private ReplyListRespDto getListRespDto(List<ReplyListResp> respList, PageDto pageDto) {
        ReplyListRespDto respDto = new ReplyListRespDto();
        respDto.setRespList(respList);
        respDto.setPageDto(pageDto);
        return respDto;
    }

    private List<ReplyListResp> queryList(JoinGroupReplyListReqDto reqDto) {
        Stopwatch sw = Stopwatch.createStarted();
        JoinGroupListParams queryParams = (JoinGroupListParams)BeanUtil.convert((Object)reqDto, JoinGroupListParams.class, (String[])new String[0]);
        int count = this.logicAutoReplyMapper.countJoinGroupListByParams(queryParams);
        queryParams.setCount(Integer.valueOf(count));
        if (count == 0) {
            return Collections.emptyList();
        }
        List replies = this.logicAutoReplyMapper.queryJoinGroupListByParams(queryParams);
        log.info("joinGroupReplyList list:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        List replyIds = replies.stream().map(LogicAutoReply::getId).collect(Collectors.toList());
        Stopwatch sw1 = Stopwatch.createStarted();
        List chatRooms = this.logicAutoReplyWechatRoomMapper.queryByReplyIds(replyIds);
        Map<Long, List<RoomToRobotDto>> chatRoomMap = chatRooms.stream().collect(Collectors.groupingBy(LogicAutoReplyWechatRoom::getAutoReplyId, Collectors.mapping(a -> new RoomToRobotDto(a.getWechatRoomName(), a.getWechatId()), Collectors.toList())));
        log.info("joinGroupReplyList list1:{}", (Object)sw1.elapsed(TimeUnit.MILLISECONDS));
        Stopwatch sw3 = Stopwatch.createStarted();
        List<ReplyListResp> replyListRespList = this.getReplyListResps(replies, chatRoomMap);
        List logicAutoReplyWordList = this.logicAutoReplyWordMapper.selectByAutoReplyIds(replyIds);
        List<Integer> charRoomList = Arrays.asList(AutoReplyRelationType.CHAT_ROOM.getValue(), AutoReplyRelationType.CHAT_ROOM_GROUP.getValue());
        replyListRespList.forEach(replyListResp -> {
            replyListResp.setPlan(!charRoomList.contains(replyListResp.getRelationType()));
            for (LogicAutoReplyWord logicAutoReplyWord : logicAutoReplyWordList) {
                if (!Objects.equals(replyListResp.getId(), logicAutoReplyWord.getAutoReplyId())) continue;
                replyListResp.setKeyWord(new AutoReplyWordDto(logicAutoReplyWord.getKeyWord(), logicAutoReplyWord.getType()));
                break;
            }
        });
        log.info("joinGroupReplyList list3:{}", (Object)sw3.elapsed(TimeUnit.MILLISECONDS));
        return replyListRespList;
    }

    private List<ReplyListResp> getReplyListResps(List<LogicAutoReply> replies, Map<Long, List<RoomToRobotDto>> chatroomMap) {
        ArrayList allMessages = Lists.newArrayList();
        ArrayList<ReplyListResp> resps = new ArrayList<ReplyListResp>(replies.size());
        replies.forEach(reply -> {
            ReplyListResp resp = (ReplyListResp)BeanUtil.convert((Object)reply, ReplyListResp.class, (String[])new String[0]);
            resp.setEnabled(Integer.valueOf(reply.getEnabled() == null ? 0 : reply.getEnabled()));
            resp.setTitle(reply.getTitle());
            resp.setId(reply.getId());
            resp.setChatRooms((List)chatroomMap.get(resp.getId()));
            resp.setRequest(reply.getRequest());
            List<AutoReplyMessageDto> messageDtos = this.replyMessageDtoService.parseAutoReplyMessageDtoList((LogicAutoReply)reply);
            resp.setReplyMessage(messageDtos);
            allMessages.addAll(messageDtos);
            resps.add(resp);
        });
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(allMessages);
        return resps;
    }
}

