/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.marketing.utils;

import com.google.common.base.Preconditions;
import com.kuaike.common.utils.EncryptUtils;
import java.nio.charset.Charset;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public final class MarketingCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(MarketingCommonUtil.class);
    public static final String CHATROOM_DRAINAGE_PREFIX = "QYL";
    public static final String WECHAT_DRAINAGE_PREFIX = "WXYL";
    public static final String CHATROOM_FISSION_PREFIX = "QLB";
    public static final String WECHAT_FISSION_PREFIX = "WXLB";
    private static String guideUrlFormat;
    private static String drainageUrlFormat;
    private static String wecahtUrlFormat;
    public static final int chatroom_drainage_plan_1 = 1;
    public static final int wechat_drainage_plan_3 = 3;
    public static final int chatroom_fission_plan_2 = 2;
    public static final int wechat_fission_plan_4 = 4;

    @Value(value="${fission.url.format}")
    public void setGuideUrlFormat(String format) {
        guideUrlFormat = format;
    }

    @Value(value="${drainage.url.format}")
    public void setDrainageUrlFormat(String format) {
        drainageUrlFormat = format;
    }

    @Value(value="${wechat.url.format}")
    public void setWecahtUrlFormat(String format) {
        wecahtUrlFormat = format;
    }

    public static String encodeMarketingPlanId(Long id, Integer type) {
        String prefix;
        if (id == null || type == null) {
            return "";
        }
        switch (type) {
            case 3: {
                prefix = WECHAT_DRAINAGE_PREFIX;
                break;
            }
            case 1: {
                prefix = CHATROOM_DRAINAGE_PREFIX;
                break;
            }
            case 2: {
                prefix = CHATROOM_FISSION_PREFIX;
                break;
            }
            case 4: {
                prefix = WECHAT_FISSION_PREFIX;
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u8425\u9500\u65b9\u6848\u7c7b\u578b\u672a\u77e5");
            }
        }
        return EncryptUtils.base64Encode((String)(prefix + id), (Charset)Charset.forName("utf8"));
    }

    public static String getAllActivityLink(Long planId, Boolean hasGuidePage, String planCode, Integer marketingType) {
        log.info("\u751f\u4ea7\u6d3b\u52a8\u94fe\u63a5\uff0cplanId:{},hasGuidePage:{},planCode:{},marketingType{}", new Object[]{planId, hasGuidePage, planCode, marketingType});
        Preconditions.checkArgument((boolean)Objects.nonNull(marketingType), (Object)"marketingType\u4e0d\u80fd\u4e3a\u7a7a");
        String idStr = MarketingCommonUtil.encodeMarketingPlanId(planId, marketingType);
        if (Objects.equals((int)marketingType, 1)) {
            return String.format(drainageUrlFormat, idStr, marketingType);
        }
        if (Objects.equals((int)marketingType, 3)) {
            return String.format(wecahtUrlFormat, idStr, marketingType, planCode);
        }
        if (Objects.equals((int)marketingType, 2)) {
            if (hasGuidePage.booleanValue()) {
                return String.format(guideUrlFormat, idStr, planCode);
            }
            return String.format(drainageUrlFormat, idStr, marketingType);
        }
        if (Objects.equals((int)marketingType, 4)) {
            if (hasGuidePage.booleanValue()) {
                return String.format(guideUrlFormat, idStr, planCode);
            }
            return String.format(wecahtUrlFormat, idStr, marketingType, planCode);
        }
        throw new UnsupportedOperationException("\u8425\u9500\u65b9\u6848\u7c7b\u578b\u672a\u77e5");
    }
}

