/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.marketing.impl;

import com.alibaba.fastjson.JSON;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoomGroupRelation;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomGroupRelationMapper;
import com.kuaike.skynet.logic.service.marketing.MarketingCommonService;
import com.kuaike.skynet.logic.service.marketing.dto.DrainageAutoReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.FissionAutoReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.MarketChatRoomConfigDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MarketingCommonServiceImpl
implements MarketingCommonService {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.marketChatConfigFormat}")
    private String marketChatConfigFormat;
    @Autowired
    private WechatChatRoomGroupRelationMapper wechatChatRoomGroupRelationMapper;
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;

    @Override
    public MarketChatRoomConfigDto getChatRoomConfig(String chatRoom) {
        MarketChatRoomConfigDto configDto = null;
        String cacheVal = "";
        Object configObject = this.redisTemplate.opsForValue().get((Object)this.getChatConfigRedisKey(chatRoom));
        if (configObject == null) {
            WechatChatRoomGroupRelation condition = new WechatChatRoomGroupRelation();
            condition.setChatRoomName(chatRoom);
            List relationList = this.wechatChatRoomGroupRelationMapper.select((Object)condition);
            if (CollectionUtils.isNotEmpty((Collection)relationList)) {
                if (configDto == null) {
                    configDto = this.getFissionConfig(relationList);
                }
                if (configDto == null) {
                    configDto = this.getDrainageConfig(relationList);
                }
                if (configDto != null) {
                    cacheVal = JacksonUtil.obj2Str((Object)configDto);
                }
            }
            this.redisTemplate.opsForValue().set((Object)this.getChatConfigRedisKey(chatRoom), (Object)cacheVal, 1L, TimeUnit.MINUTES);
        } else {
            cacheVal = configObject.toString();
            if (StringUtils.isNotEmpty((CharSequence)cacheVal)) {
                configDto = (MarketChatRoomConfigDto)JSON.parseObject((String)cacheVal, MarketChatRoomConfigDto.class);
            }
        }
        return configDto;
    }

    private MarketChatRoomConfigDto getFissionConfig(List<WechatChatRoomGroupRelation> relationList) {
        MarketChatRoomConfigDto configDto = null;
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            MarketReplyConfig replyConfig = this.marketReplyConfigMapper.getConfigByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (replyConfig == null) break;
            FissionAutoReplyConfig fissionAutoReplyConfig = (FissionAutoReplyConfig)JSON.parseObject((String)replyConfig.getJsonText(), FissionAutoReplyConfig.class);
            configDto = new MarketChatRoomConfigDto();
            configDto.setChatRoom(relation.getChatRoomName());
            configDto.setIsAutoReply(fissionAutoReplyConfig.getIsAutoReply());
            configDto.setReplyCall(fissionAutoReplyConfig.getReplyCall());
            configDto.setRelationType(AutoReplyRelationType.FISSION_PLAN.getValue());
            configDto.setMarketPlanId(replyConfig.getExtendedId());
            break;
        }
        return configDto;
    }

    private MarketChatRoomConfigDto getDrainageConfig(List<WechatChatRoomGroupRelation> relationList) {
        MarketChatRoomConfigDto configDto = null;
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getDrainageCategoryId() == null) continue;
            MarketReplyConfig replyConfig = this.marketReplyConfigMapper.getConfigByDrainageCategoryPlanId(relation.getDrainageCategoryId(), new Date());
            if (replyConfig == null) break;
            DrainageAutoReplyConfig drainageAutoReplyConfig = (DrainageAutoReplyConfig)JSON.parseObject((String)replyConfig.getJsonText(), DrainageAutoReplyConfig.class);
            configDto = new MarketChatRoomConfigDto();
            configDto.setChatRoom(relation.getChatRoomName());
            configDto.setIsAutoReply(drainageAutoReplyConfig.getIsAutoReply());
            configDto.setReplyCall(drainageAutoReplyConfig.getReplyCall());
            configDto.setRelationType(AutoReplyRelationType.DRAINAGE_PLAN.getValue());
            configDto.setMarketPlanId(replyConfig.getExtendedId());
            break;
        }
        return configDto;
    }

    private String getChatConfigRedisKey(String chatRoom) {
        return String.format(this.marketChatConfigFormat, chatRoom);
    }
}

