/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.marketing.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMapper;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MarketReplyConfigType;
import com.kuaike.skynet.logic.service.marketing.GroupFissionService;
import com.kuaike.skynet.logic.service.marketing.dto.FissionJoinGroupReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.FissionRewardReplyConfig;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class GroupFissionServiceImpl
implements GroupFissionService {
    private static final Logger log = LoggerFactory.getLogger(GroupFissionServiceImpl.class);
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;
    @Autowired
    private LogicIntervalSendMessageMapper logicIntervalSendMessageMapper;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.fissionRewardMap}")
    private String fissionRewardMapKey;

    @Override
    public String getFissionJoinGroupReply(Long fissionCategoryId) {
        if (fissionCategoryId == null) {
            return null;
        }
        MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getJoinGroupByFissionCategoryPlanId(fissionCategoryId, new Date());
        if (marketReplyConfig == null) {
            return null;
        }
        FissionJoinGroupReplyConfig replyConfig = (FissionJoinGroupReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionJoinGroupReplyConfig.class);
        ReplyMessageDto replyMessageDto = new ReplyMessageDto(replyConfig.getJoinGroupReplyMessages());
        String message = JacksonUtil.obj2Str((Object)replyMessageDto);
        return message;
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getRewordConfig() {
        Map<String, HashMap> dataMap = Maps.newHashMap();
        Object redisObject = this.redisTemplate.opsForValue().get((Object)this.fissionRewardMapKey);
        if (redisObject == null) {
            List jsonTextList = this.marketReplyConfigMapper.queryRewardByWechatId(Integer.valueOf(MarketReplyConfigType.FISSION_TASK_REWARD.getValue()), new Date());
            if (CollectionUtils.isNotEmpty((Collection)jsonTextList)) {
                for (String jsonText : jsonTextList) {
                    FissionRewardReplyConfig replyConfig = (FissionRewardReplyConfig)JSON.parseObject((String)jsonText, FissionRewardReplyConfig.class);
                    HashMap dataPacketMap = Maps.newHashMapWithExpectedSize((int)3);
                    dataPacketMap.put("name", replyConfig.getDataPacketName());
                    dataPacketMap.put("url", replyConfig.getDataPacketUrl());
                    List<AutoReplyMessageDto> rewardMessages = replyConfig.getRewardMessages();
                    if (CollectionUtils.isNotEmpty(rewardMessages)) {
                        String messages = JacksonUtil.obj2Str(rewardMessages);
                        dataPacketMap.put("rewardMessages", messages);
                    }
                    HashMap dataPacketMapWrap = Maps.newHashMapWithExpectedSize((int)1);
                    dataPacketMapWrap.put(replyConfig.getWechatId(), dataPacketMap);
                    dataMap.put(replyConfig.getSignal(), dataPacketMapWrap);
                }
            }
            log.info("reward caching failed, recache reward with data={}", (Object)JacksonUtil.obj2Str((Object)dataMap));
            this.redisTemplate.opsForValue().set((Object)this.fissionRewardMapKey, (Object)JacksonUtil.obj2Str((Object)dataMap), 30L, TimeUnit.SECONDS);
        } else {
            dataMap = (Map)JSON.parse((String)redisObject.toString());
        }
        return dataMap;
    }

    @Override
    public boolean existGroupFissionTask(String wechatId, String chatRoomName, String memberWechatId, Long fissionCategoryId) {
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("wechatId", wechatId);
        mapParam.put("wechatRoomName", chatRoomName);
        mapParam.put("memberWechatId", memberWechatId);
        mapParam.put("fissionCategoryId", fissionCategoryId);
        mapParam.put("replyType", IntervalMessageReplyTypeEnum.FISSION_TASK_COMPLETE.getValue());
        int num = this.logicIntervalSendMessageMapper.existFissionTaskCount((Map)mapParam);
        boolean flag = num > 0;
        log.info("exist fission count={}, chatRoomName={}, memberWechatId={}, fissionCategoryId={}", new Object[]{num, chatRoomName, memberWechatId, fissionCategoryId});
        return flag;
    }
}

