/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.marketing.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.skynet.logic.dal.market.entity.FissionPlan;
import com.kuaike.skynet.logic.dal.market.entity.FissionPlanGuide;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfigCriteria;
import com.kuaike.skynet.logic.dal.market.mapper.FissionPlanGuideMapper;
import com.kuaike.skynet.logic.dal.market.mapper.FissionPlanMapper;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.marketing.FissionPlanService;
import com.kuaike.skynet.logic.service.marketing.dto.FissionGuideConfig;
import com.kuaike.skynet.logic.service.marketing.dto.MarketingDeliveryPatterCommonDto;
import com.kuaike.skynet.logic.service.marketing.utils.MarketingCommonUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FissionPlanServiceImpl
implements FissionPlanService {
    private static final Logger log = LoggerFactory.getLogger(FissionPlanServiceImpl.class);
    @Autowired
    private FissionPlanMapper fissionPlanMapper;
    @Autowired
    private FissionPlanGuideMapper fissionPlanGuideMapper;
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;

    @Override
    public List<FissionPlan> queryByIds(Collection<Long> ids) {
        log.info("query fission plan list with ids={}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.fissionPlanMapper.queryByIds(ids);
    }

    @Override
    public String queryFissionContentById(Long fissionPlanId) {
        if (fissionPlanId == null) {
            return null;
        }
        FissionPlan fissionPlan = this.fissionPlanMapper.queryById(fissionPlanId);
        Preconditions.checkArgument((boolean)Objects.nonNull(fissionPlan), (Object)("\u65e0id\u4e3a" + fissionPlanId + "\u7684\u65b9\u6848"));
        MarketReplyConfigCriteria configCriteria = new MarketReplyConfigCriteria();
        MarketReplyConfigCriteria.Criteria criteria = configCriteria.createCriteria();
        criteria.andIsDeletedEqualTo(Boolean.valueOf(false)).andExtendedIdEqualTo(fissionPlan.getId());
        if (Objects.equals(fissionPlan.getMarketingPlanType(), 2)) {
            criteria.andConfigTypeEqualTo(Integer.valueOf(11));
        } else {
            criteria.andConfigTypeEqualTo(Integer.valueOf(21));
        }
        List configs = this.marketReplyConfigMapper.selectByExample((Object)configCriteria);
        String result = null;
        if (CollectionUtils.isNotEmpty((Collection)configs)) {
            MarketReplyConfig config = (MarketReplyConfig)configs.get(0);
            try {
                boolean hasGuidePage;
                MarketingDeliveryPatterCommonDto marketingDeliveryPatterCommonDto = (MarketingDeliveryPatterCommonDto)JSON.parseObject((String)config.getJsonText(), MarketingDeliveryPatterCommonDto.class);
                String activityUrl = null;
                if (Objects.equals(fissionPlan.getMarketingPlanType(), 2)) {
                    FissionPlanGuide fissionPlanGuide = this.fissionPlanGuideMapper.queryByFissionPlanId(fissionPlanId);
                    Preconditions.checkArgument((boolean)Objects.nonNull(fissionPlanGuide), (Object)("\u65e0id\u4e3a" + fissionPlanId + "\u7684guideConfig"));
                    hasGuidePage = fissionPlanGuide != null && fissionPlanGuide.getIsAutoReply() == 1;
                    activityUrl = MarketingCommonUtil.getAllActivityLink(fissionPlan.getId(), hasGuidePage, fissionPlan.getCode(), 2);
                } else {
                    Integer fissionGuideConfig = this.getFissionGuideConfig(fissionPlanId, 22);
                    hasGuidePage = fissionGuideConfig != null && fissionGuideConfig == 1;
                    activityUrl = MarketingCommonUtil.getAllActivityLink(fissionPlan.getId(), hasGuidePage, fissionPlan.getCode(), 4);
                }
                CommonMessage commonMessage = new CommonMessage();
                commonMessage.setContent(activityUrl);
                commonMessage.setSeq(Integer.valueOf(2));
                commonMessage.setType(Integer.valueOf(1));
                List<Object> deliveryPatterMessages = marketingDeliveryPatterCommonDto.getDeliveryPatterMessages();
                deliveryPatterMessages.add(commonMessage);
                deliveryPatterMessages = deliveryPatterMessages.stream().sorted(Comparator.comparing(CommonMessage::getSeq)).collect(Collectors.toList());
                result = deliveryPatterMessages.stream().map(CommonMessage::getContent).collect(Collectors.joining("\n"));
            }
            catch (Exception e) {
                log.error("json\u89e3\u6790\u65f6\u53d1\u751f\u5f02\u5e38,fissionPlanId:{}, exception:{}, jsonText:{}", new Object[]{fissionPlanId, e, config.getJsonText()});
            }
        }
        return result;
    }

    private Integer getFissionGuideConfig(Long planId, Integer configType) {
        MarketReplyConfigCriteria configCriteria = new MarketReplyConfigCriteria();
        MarketReplyConfigCriteria.Criteria criteria = configCriteria.createCriteria();
        criteria.andIsDeletedEqualTo(Boolean.valueOf(false)).andExtendedIdEqualTo(planId).andConfigTypeEqualTo(configType);
        List configs = this.marketReplyConfigMapper.selectByExample((Object)configCriteria);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)configs), (Object)("\u65e0\u6548\u53c2\u6570\uff0cplanId:" + planId + ",configType:" + configType));
        FissionGuideConfig fissionGuideConfig = (FissionGuideConfig)JSON.parseObject((String)((MarketReplyConfig)configs.get(0)).getJsonText(), FissionGuideConfig.class);
        Preconditions.checkArgument((boolean)Objects.nonNull(fissionGuideConfig), (Object)("\u65e0\u6548\u53c2\u65702\uff0cplanId:" + planId + ",configType:" + configType));
        return fissionGuideConfig.getIsOpenGuide();
    }
}

