/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.marketing.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.skynet.logic.dal.market.entity.DrainagePlan;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfigCriteria;
import com.kuaike.skynet.logic.dal.market.mapper.DrainagePlanMapper;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.marketing.DrainagePlanService;
import com.kuaike.skynet.logic.service.marketing.dto.MarketingDeliveryPatterCommonDto;
import com.kuaike.skynet.logic.service.marketing.utils.MarketingCommonUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrainagePlanServiceImpl
implements DrainagePlanService {
    private static final Logger log = LoggerFactory.getLogger(DrainagePlanServiceImpl.class);
    @Autowired
    private DrainagePlanMapper drainagePlanMapper;
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;

    @Override
    public List<DrainagePlan> queryByIds(Collection<Long> ids) {
        log.info("query drainage plan list with ids={}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.drainagePlanMapper.queryByIds(ids);
    }

    @Override
    public String queryDrainageContentById(Long drainagePlanId) {
        if (drainagePlanId == null) {
            return null;
        }
        DrainagePlan drainagePlan = this.drainagePlanMapper.queryById(drainagePlanId);
        Preconditions.checkArgument((boolean)Objects.nonNull(drainagePlan), (Object)("\u65e0id\u4e3a" + drainagePlanId + "\u7684\u65b9\u6848"));
        MarketReplyConfigCriteria configCriteria = new MarketReplyConfigCriteria();
        MarketReplyConfigCriteria.Criteria criteria = configCriteria.createCriteria();
        criteria.andIsDeletedEqualTo(Boolean.valueOf(false)).andExtendedIdEqualTo(drainagePlan.getId());
        if (Objects.equals(drainagePlan.getMarketingPlanType(), 1)) {
            criteria.andConfigTypeEqualTo(Integer.valueOf(40));
        } else {
            criteria.andConfigTypeEqualTo(Integer.valueOf(61));
        }
        List configs = this.marketReplyConfigMapper.selectByExample((Object)configCriteria);
        String result = null;
        if (CollectionUtils.isNotEmpty((Collection)configs)) {
            MarketReplyConfig config = (MarketReplyConfig)configs.get(0);
            try {
                MarketingDeliveryPatterCommonDto marketingDeliveryPatterCommonDto = (MarketingDeliveryPatterCommonDto)JSON.parseObject((String)config.getJsonText(), MarketingDeliveryPatterCommonDto.class);
                String activityUrl = null;
                activityUrl = Objects.equals(drainagePlan.getMarketingPlanType(), 1) ? MarketingCommonUtil.getAllActivityLink(drainagePlan.getId(), null, drainagePlan.getCode(), 1) : MarketingCommonUtil.getAllActivityLink(drainagePlan.getId(), null, drainagePlan.getCode(), 3);
                CommonMessage commonMessage = new CommonMessage();
                commonMessage.setContent(activityUrl);
                commonMessage.setSeq(Integer.valueOf(2));
                commonMessage.setType(Integer.valueOf(1));
                List<Object> deliveryPatterMessages = marketingDeliveryPatterCommonDto.getDeliveryPatterMessages();
                deliveryPatterMessages.add(commonMessage);
                deliveryPatterMessages = deliveryPatterMessages.stream().sorted(Comparator.comparing(CommonMessage::getSeq)).collect(Collectors.toList());
                result = deliveryPatterMessages.stream().map(CommonMessage::getContent).collect(Collectors.joining("\n"));
            }
            catch (Exception e) {
                log.error("json\u89e3\u6790\u65f6\u53d1\u751f\u5f02\u5e38,drainagePlanId:{}, exception:{}, jsonText:{}", new Object[]{drainagePlanId, e, config.getJsonText()});
            }
        }
        return result;
    }
}

