/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug.impl;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.wechat.dto.ChatRoomMember;
import com.kuaike.skynet.logic.dal.wechat.dto.WechatAccountDto;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatContact;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomRelationMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatContactMapper;
import com.kuaike.skynet.logic.service.cache.BlacklistCacheService;
import com.kuaike.skynet.logic.service.cache.DrainageKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.FissionKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.FriendKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.GroupKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.ReplyOptionCacheService;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedOption;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.debug.DebugService;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import com.kuaike.skynet.logic.service.debug.dto.MemPrintStream;
import com.kuaike.skynet.logic.service.marketing.GroupFissionService;
import com.kuaike.skynet.logic.service.marketing.MarketingCommonService;
import com.kuaike.skynet.logic.service.marketing.dto.MarketChatRoomConfigDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KeywordDebugService
implements DebugService {
    private static final Logger log = LoggerFactory.getLogger(KeywordDebugService.class);
    private final Options options = new Options();
    @Autowired
    private MarketingCommonService marketingCommonService;
    @Autowired
    private DrainageKeywordCacheService drainageKeywordCacheService;
    @Autowired
    private FissionKeywordCacheService fissionKeywordCacheService;
    @Autowired
    private GroupKeywordCacheService groupKeywordCacheService;
    @Autowired
    private FriendKeywordCacheService friendKeywordCacheService;
    @Autowired
    private GroupFissionService groupFissionService;
    @Autowired
    private ReplyOptionCacheService replyOptionCacheService;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private BlacklistCacheService blacklistCacheService;
    @Autowired
    private WechatContactMapper wechatContactMapper;
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;
    @Autowired
    private WechatChatRoomRelationMapper wechatChatRoomRelationMapper;

    public KeywordDebugService() {
        this.options.addOption("h", "help", false, "\u5e2e\u52a9");
        this.options.addOption("c", "chatroom", true, "\u5fae\u4fe1\u7fa4");
        this.options.addOption("w", "wechat", true, "\u5fae\u4fe1\u53f7");
        this.options.addOption("t", "talker", true, "\u7279\u5b9a\u4eba\u89e6\u53d1\u5173\u952e\u8bcd");
    }

    @Override
    public String getCmd() {
        return "keyword";
    }

    @Override
    public DebugResult process(String wechatId, String talkerId, String ... args) {
        CommandLine cmd;
        log.info("process keyword cmd with wechatId={}, args={}", (Object)wechatId, (Object)Arrays.toString(args));
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(this.options, args, true);
        }
        catch (ParseException e) {
            return DebugResult.error(2, e.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)cmd.getArgList())) {
            return DebugResult.help(this.getCmd(), this.options);
        }
        if (cmd.hasOption("h")) {
            return DebugResult.help(this.getCmd(), this.options);
        }
        String keyword = StringUtils.join((Iterable)cmd.getArgList(), (String)" ");
        if (cmd.hasOption("t")) {
            talkerId = cmd.getOptionValue("t");
        }
        if (cmd.hasOption("w")) {
            wechatId = cmd.getOptionValue("w");
        }
        if (cmd.hasOption("c")) {
            String chatroomId = cmd.getOptionValue("c");
            return this.groupKeyword(wechatId, chatroomId, talkerId, keyword);
        }
        return this.friendKeyword(wechatId, talkerId, keyword);
    }

    public DebugResult friendKeyword(String wechatId, String talkerId, String keyword) {
        WechatAccountDto ac = this.wechatAccountCacheService.getAccount(wechatId);
        if (ac == null) {
            return DebugResult.ok(wechatId + "\u4e0d\u662f\u7cfb\u7edf\u5fae\u4fe1\u53f7\uff0c\u4e0d\u53ef\u80fd\u89e6\u53d1\u81ea\u52a8\u56de\u590d\u3002");
        }
        WechatContact contact = this.wechatContactMapper.getContact(wechatId, talkerId);
        Long businessCustomerId = ac.getBusinessCustomerId();
        MemPrintStream out = new MemPrintStream();
        out.getPrintWriter().printf("\u79c1\u804a\u5173\u952e\u8bcd\u81ea\u52a8\u56de\u590d\n", keyword);
        out.getPrintWriter().printf("\u673a\u5668\u4eba: [%s], %s\n", wechatId, ac.getNickname());
        out.getPrintWriter().printf("\u673a\u5668\u4eba\u5546\u6237: [%d]\n", businessCustomerId);
        out.getPrintWriter().printf("\u8054\u7cfb\u4eba: [%s], %s\n", talkerId, contact == null ? "\u4e0d\u662f\u8054\u7cfb\u4eba" : contact.getNickname());
        out.getPrintWriter().printf("\u5173\u952e\u8bcd: %s\n", keyword);
        out.getPrintWriter().printf("\u5339\u914d\u7ed3\u679c\u5982\u4e0b:\n", new Object[0]);
        if (this.blacklistCacheService.inBlacklist(businessCustomerId, talkerId)) {
            out.getPrintWriter().printf("\u8be5\u8054\u7cfb\u4eba[%s]\u5df2\u88ab\u62c9\u9ed1\uff0c\u65e0\u6cd5\u89e6\u53d1\u5173\u952e\u8bcd\u56de\u590d\u3002", talkerId);
            return DebugResult.ok(out.toString());
        }
        CachedReplyMsg option = null;
        if (StringUtils.isNotBlank((CharSequence)talkerId)) {
            option = this.getFriendOption(businessCustomerId, wechatId, talkerId, keyword);
        }
        out.getPrintWriter().printf("1. \u8bb0\u5fc6\u9009\u9879: ", new Object[0]);
        if (option == null) {
            out.getPrintWriter().println("\u6ca1\u6709\u547d\u4e2d");
        } else {
            out.getPrintWriter().println();
            out.getPrintWriter().println(JacksonUtil.obj2Str((Object)option));
        }
        Map<String, String> reward = this.fissionReply(wechatId, keyword);
        out.getPrintWriter().printf("2. \u5956\u52b1\u6697\u53f7: ", new Object[0]);
        if (reward == null) {
            out.getPrintWriter().println("\u6ca1\u6709\u547d\u4e2d");
        } else {
            out.getPrintWriter().println();
            out.getPrintWriter().println(JacksonUtil.obj2Str(reward));
        }
        List<CachedReplyMsg> matched = this.friendKeywordReply(wechatId, keyword);
        out.getPrintWriter().printf("3. \u79c1\u804a\u5173\u952e\u8bcd: ", new Object[0]);
        if (CollectionUtils.isEmpty(matched)) {
            out.getPrintWriter().println("\u6ca1\u6709\u547d\u4e2d");
        } else {
            out.getPrintWriter().println();
            for (CachedReplyMsg msg : matched) {
                out.getPrintWriter().println(JacksonUtil.obj2Str((Object)msg));
            }
        }
        return DebugResult.ok(out.toString());
    }

    public CachedReplyMsg getFriendOption(Long buId, String wechatId, String talkerId, String text) {
        if (!StringUtils.isNumeric((CharSequence)text)) {
            return null;
        }
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(buId, wechatId, talkerId);
        CachedOption cache = this.replyOptionCacheService.getCachedOption(redisKey);
        CachedReplyMsg result = this.replyOptionCacheService.getValidOption(cache, text);
        return result;
    }

    private Map<String, String> fissionReply(String wechatId, String message) {
        Map dataMap = this.groupFissionService.getRewordConfig();
        if (MapUtils.isEmpty((Map)dataMap)) {
            return null;
        }
        Map dataPackageMap = (Map)dataMap.get(message);
        if (MapUtils.isEmpty((Map)dataPackageMap)) {
            return null;
        }
        Map reward = (Map)dataPackageMap.get(wechatId);
        if (MapUtils.isEmpty((Map)reward)) {
            return null;
        }
        return reward;
    }

    private List<CachedReplyMsg> friendKeywordReply(String wechatId, String keyword) {
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        MatchedResult result = this.friendKeywordCacheService.match(businessCustomerId, (Object)wechatId, keyword);
        List matched = result.getList();
        return matched;
    }

    public DebugResult groupKeyword(String wechatId, String chatroomId, String talkerId, String keyword) {
        List matched;
        MatchedResult result;
        WechatAccountDto ac = this.wechatAccountCacheService.getAccount(wechatId);
        if (ac == null) {
            return DebugResult.ok(wechatId + "\u4e0d\u662f\u7cfb\u7edf\u5fae\u4fe1\u53f7\uff0c\u4e0d\u53ef\u80fd\u89e6\u53d1\u81ea\u52a8\u3002");
        }
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        WechatChatRoom room = this.wechatChatRoomMapper.queryByName(chatroomId);
        if (room == null) {
            return DebugResult.ok("\u627e\u4e0d\u5230\u5fae\u4fe1\u7fa4[" + chatroomId + "], \u65e0\u6cd5\u89e6\u53d1\u81ea\u52a8\u56de\u590d\u3002");
        }
        ChatRoomMember member = this.wechatChatRoomRelationMapper.getChatRoomMember(chatroomId, talkerId);
        MemPrintStream out = new MemPrintStream();
        out.getPrintWriter().printf("\u7fa4\u804a\u5173\u952e\u8bcd\u81ea\u52a8\u56de\u590d\n", keyword);
        out.getPrintWriter().printf("\u673a\u5668\u4eba: [%s], %s\n", wechatId, ac.getNickname());
        out.getPrintWriter().printf("\u673a\u5668\u4eba\u5546\u6237: [%d]\n", businessCustomerId);
        out.getPrintWriter().printf("\u5fae\u4fe1\u7fa4: [%s], %s(%d)\n", chatroomId, room.getNickName(), room.getMemberCount());
        out.getPrintWriter().printf("\u7fa4\u6210\u5458: [%s], %s\n", talkerId, member == null ? "\u4e0d\u662f\u7fa4\u6210\u5458" : member.getNickname());
        out.getPrintWriter().printf("\u5173\u952e\u8bcd: %s\n", keyword);
        out.getPrintWriter().printf("\u5339\u914d\u7ed3\u679c\u5982\u4e0b:\n", new Object[0]);
        if (this.blacklistCacheService.inBlacklist(businessCustomerId, talkerId)) {
            out.getPrintWriter().printf("\u8be5\u7fa4\u6210\u5458[%s]\u5df2\u88ab\u62c9\u9ed1\uff0c\u65e0\u6cd5\u89e6\u53d1\u5173\u952e\u8bcd\u56de\u590d\u3002", talkerId);
            return DebugResult.ok(out.toString());
        }
        CachedReplyMsg option = null;
        if (StringUtils.isNotBlank((CharSequence)talkerId)) {
            option = this.getGroupOption(businessCustomerId, chatroomId, talkerId, keyword);
        }
        out.getPrintWriter().printf("1. \u8bb0\u5fc6\u9009\u9879: ", new Object[0]);
        if (option == null) {
            out.getPrintWriter().println("\u6ca1\u6709\u547d\u4e2d");
        } else {
            out.getPrintWriter().println();
            out.getPrintWriter().println(JacksonUtil.obj2Str((Object)option));
        }
        out.getPrintWriter().printf("2. \u8425\u9500\u6d3b\u52a8: ", new Object[0]);
        MarketChatRoomConfigDto config = this.marketingCommonService.getChatRoomConfig(chatroomId);
        if (config == null) {
            out.getPrintWriter().println("\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u7684\u6d3b\u52a8");
        } else {
            out.getPrintWriter().printf("\u5f53\u524d\u6d3b\u52a8id=%d, type=%d\n", config.getMarketPlanId(), config.getRelationType());
            if (config.getIsAutoReply().equals(1)) {
                result = null;
                matched = null;
                if (AutoReplyRelationType.FISSION_PLAN.getValue() == config.getRelationType().intValue()) {
                    result = this.fissionKeywordCacheService.match((Object)config.getMarketPlanId(), keyword);
                    matched = result.getList();
                } else if (AutoReplyRelationType.DRAINAGE_PLAN.getValue() == config.getRelationType().intValue()) {
                    result = this.drainageKeywordCacheService.match((Object)config.getMarketPlanId(), keyword);
                    matched = result.getList();
                } else {
                    return null;
                }
                if (CollectionUtils.isNotEmpty((Collection)matched)) {
                    for (CachedReplyMsg msg : matched) {
                        out.getPrintWriter().println(JacksonUtil.obj2Str((Object)msg));
                    }
                } else {
                    out.getPrintWriter().println("\u6ca1\u6709\u547d\u4e2d\u5173\u952e\u8bcd");
                }
            } else {
                out.getPrintWriter().println("\u8be5\u6d3b\u52a8\u5173\u95ed\u4e86\u81ea\u52a8\u56de\u590d");
            }
        }
        result = this.groupKeywordCacheService.match(businessCustomerId, (Object)chatroomId, keyword);
        matched = result.getList();
        out.getPrintWriter().printf("3. \u7fa4\u804a\u5173\u952e\u8bcd: ", new Object[0]);
        if (CollectionUtils.isEmpty((Collection)matched)) {
            out.getPrintWriter().println("\u6ca1\u6709\u547d\u4e2d");
        } else {
            out.getPrintWriter().println();
            for (CachedReplyMsg msg : matched) {
                out.getPrintWriter().println(JacksonUtil.obj2Str((Object)msg));
            }
        }
        return DebugResult.ok(out.toString());
    }

    public CachedReplyMsg getGroupOption(Long buId, String chatroomId, String chatroomTalkerId, String text) {
        if (!StringUtils.isNumeric((CharSequence)text)) {
            return null;
        }
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(buId, chatroomId, chatroomTalkerId);
        CachedOption cache = this.replyOptionCacheService.getCachedOption(redisKey);
        CachedReplyMsg result = this.replyOptionCacheService.getValidOption(cache, text);
        return result;
    }
}

