/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug.dto;

import com.kuaike.skynet.logic.service.debug.dto.MemPrintStream;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class DebugResult {
    public static final int MAX_LENGTH = 1024;
    private boolean valid;
    private int code;
    private String msg;

    public static DebugResult invalid() {
        return new DebugResult(false, -1, "invalid user");
    }

    public static DebugResult error(int code, String msg) {
        return new DebugResult(true, code, msg);
    }

    public static DebugResult ok(String msg) {
        return new DebugResult(true, 0, msg);
    }

    public static DebugResult help(String cmd, Options options) {
        MemPrintStream out = new MemPrintStream();
        int width = 40;
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp(out.getPrintWriter(), width, cmd, "\u53c2\u6570:", options, 2, 1, null, true);
        String text = new String(out.toByteArray());
        return DebugResult.ok(text);
    }

    public static DebugResult exception(Throwable ex) {
        MemPrintStream out = new MemPrintStream();
        ex.printStackTrace(out.getPrintWriter());
        String text = out.toString();
        if (text.length() > 1024) {
            text = text.substring(0, 1024);
        }
        return DebugResult.error(-1, text);
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugResult)) {
            return false;
        }
        DebugResult other = (DebugResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebugResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "DebugResult(valid=" + this.isValid() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }

    public DebugResult() {
    }

    public DebugResult(boolean valid, int code, String msg) {
        this.valid = valid;
        this.code = code;
        this.msg = msg;
    }
}

