/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.convert.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatFile;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatFileCriteria;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatFileMapper;
import com.kuaike.skynet.logic.service.convert.FileConvertService;
import com.kuaike.skynet.logic.service.convert.dto.ResolvedAmrBasicInfoDto;
import com.kuaike.skynet.logic.service.message.EsMessageService;
import com.kuaike.skynet.logic.utils.AliyunOssUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class FileConvertServiceImpl
implements FileConvertService {
    private static final Logger log = LoggerFactory.getLogger(FileConvertServiceImpl.class);
    @Autowired
    private EsMessageService esMessageService;
    @Autowired
    private WechatFileMapper wechatFileMapper;
    @Value(value="${skynet.file.convert.url}")
    private String basePath;
    private static final String FILE_TYPE_AMR = "amr";
    private static final String FILE_TYPE_MP3_SUFFIX = ".mp3";
    private Cache<String, Object> fileConvertRecorder = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).initialCapacity(1000).build();
    private Object existsObject = new Object();
    private Object newObject = new Object();
    static final ThreadPoolExecutor service = (ThreadPoolExecutor)Executors.newCachedThreadPool();

    public ResolvedAmrBasicInfoDto convertMessageAmrToMp3(String requestId) {
        long startTime = System.currentTimeMillis();
        log.info("convertMessageAmrToMp3 requestId:{}", (Object)requestId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{requestId}), (Object)"request illegal");
        ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto = new ResolvedAmrBasicInfoDto();
        Object presentObject = this.fileConvertRecorder.getIfPresent((Object)requestId);
        if (Objects.nonNull(presentObject) && this.existsObject == presentObject) {
            log.warn("request is already processed, requestId={}", (Object)requestId);
            return resolvedAmrBasicInfoDto;
        }
        this.fileConvertRecorder.put((Object)requestId, this.existsObject);
        WechatMessage wechatMessage = null;
        try {
            wechatMessage = this.esMessageService.getByRequestId(requestId);
        }
        catch (Exception e) {
            log.error("convertMessageAmrToMp3 getByRequestId error,", (Throwable)e);
            this.fileConvertRecorder.put((Object)requestId, this.newObject);
        }
        if (Objects.isNull(wechatMessage)) {
            log.warn("wechatMessage is null, requestId={}", (Object)requestId);
            return resolvedAmrBasicInfoDto;
        }
        log.info("convertMessageAmrToMp3 wechatMessage:{}", (Object)wechatMessage);
        Preconditions.checkArgument((boolean)Objects.nonNull(wechatMessage), (Object)"\u83b7\u53d6\u4e0d\u5230\u6d88\u606f");
        if (StringUtils.isNotBlank((CharSequence)wechatMessage.getTranscodeFileUrl())) {
            log.info("convertMessageAmrToMp3 requestId:{}, time:{}", (Object)requestId, (Object)(System.currentTimeMillis() - startTime));
            this.fileConvertRecorder.put((Object)requestId, this.newObject);
            return ResolvedAmrBasicInfoDto.of((String)wechatMessage.getTranscodeFileUrl(), (Integer)wechatMessage.getDuration());
        }
        String amrPath = wechatMessage.getFileUrl();
        if (StringUtils.isBlank((CharSequence)amrPath) && StringUtils.isNotBlank((CharSequence)wechatMessage.getImgPath())) {
            List<WechatFile> wechatFiles = this.selectFileByFileKey(wechatMessage.getImgPath());
            if (CollectionUtils.isEmpty(wechatFiles)) {
                wechatFiles = this.selectFileByFileKey(wechatMessage.getRequestId());
            }
            if (CollectionUtils.isNotEmpty(wechatFiles)) {
                amrPath = wechatFiles.get(0).getFileUrl();
            }
        }
        if (StringUtils.isBlank((CharSequence)amrPath)) {
            log.warn("message amrPath is null, requestId:{}", (Object)requestId);
            return resolvedAmrBasicInfoDto;
        }
        ResolvedAmrBasicInfoDto newResolvedAmrBasicInfoDto = this.downloadAmrFileAndUploadMp3File(amrPath);
        if (Objects.nonNull(newResolvedAmrBasicInfoDto) && StringUtils.isBlank((CharSequence)newResolvedAmrBasicInfoDto.getResolvedPath())) {
            log.warn("Convert amr failed");
            return newResolvedAmrBasicInfoDto;
        }
        WechatMessage message = wechatMessage;
        service.execute(() -> {
            this.esMessageService.updateMessage(requestId, newResolvedAmrBasicInfoDto);
            this.updateFile(newResolvedAmrBasicInfoDto, message);
            this.fileConvertRecorder.put((Object)requestId, this.newObject);
        });
        log.info("convertMessageAmrToMp3 requestId:{}, time:{}", (Object)requestId, (Object)(System.currentTimeMillis() - startTime));
        return newResolvedAmrBasicInfoDto;
    }

    private void updateFile(ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto, WechatMessage wechatMessage) {
        List<WechatFile> wechatFiles = this.selectFileByFileKey(wechatMessage.getImgPath());
        if (CollectionUtils.isEmpty(wechatFiles)) {
            wechatFiles = this.selectFileByFileKey(wechatMessage.getRequestId());
        }
        if (CollectionUtils.isNotEmpty(wechatFiles)) {
            wechatFiles.stream().forEach(wechatFile -> {
                if (!Objects.equals(resolvedAmrBasicInfoDto.getResolvedPath(), wechatFile.getTranscodeFileUrl())) {
                    wechatFile.setTranscodeFileUrl(resolvedAmrBasicInfoDto.getResolvedPath());
                    if (Objects.nonNull(resolvedAmrBasicInfoDto.getDuration())) {
                        wechatFile.setDuration(resolvedAmrBasicInfoDto.getDuration());
                    }
                    this.wechatFileMapper.updateByPrimaryKeySelective(wechatFile);
                    log.info("updateFile success WechatFile:{}", wechatFile);
                }
            });
        } else {
            log.warn("updateFile is not found; wechatMessage:{}", (Object)wechatMessage);
        }
    }

    private List<WechatFile> selectFileByFileKey(String fileKey) {
        WechatFileCriteria criteria = new WechatFileCriteria();
        criteria.createCriteria().andIsDeletedEqualTo(Boolean.valueOf(false)).andFileKeyEqualTo(fileKey);
        return this.wechatFileMapper.selectByExample((Object)criteria);
    }

    public ResolvedAmrBasicInfoDto downloadAmrFileAndUploadMp3File(String amrPath) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)amrPath), (Object)"amrPath is not blank");
        log.info("downloadAmrFileAndUploadMp3File amrPath:{}", (Object)amrPath);
        String extName = FilenameUtils.getExtension((String)amrPath);
        String fileName = FilenameUtils.getBaseName((String)amrPath);
        String fileKey = FileConvertServiceImpl.getFileKey(amrPath, fileName);
        log.info("basePath:{}, extName: {}, fileName:{}, fileKey:{}", new Object[]{this.basePath, extName, fileName, fileKey});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileKey), (Object)"fileKey is not null; amrPath is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.basePath), (Object)"basePath is not null");
        Preconditions.checkArgument((boolean)Objects.equals(FILE_TYPE_AMR, extName), (String)"illegal filePath amrPath:{}", (Object)amrPath);
        ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto = new ResolvedAmrBasicInfoDto();
        String aliYunUrl = null;
        Boolean errorFlag = false;
        StopWatch watch = new StopWatch();
        watch.start();
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpClientUtils.download((String)amrPath);
        }
        catch (Exception e) {
            errorFlag = true;
            log.error("downloadAmrFileAndUploadMp3File download error; amrPath:{}, e", (Object)amrPath, (Object)e);
            e.printStackTrace();
        }
        watch.stop();
        log.info("\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6\uff1a{},amrPath:{}", (Object)watch.getLastTaskTimeMillis(), (Object)amrPath);
        if (errorFlag.booleanValue()) {
            return resolvedAmrBasicInfoDto;
        }
        watch.start();
        String localPath = FilenameUtils.getName((String)amrPath);
        File source = new File(localPath);
        try {
            IOUtils.write((byte[])bytes, (OutputStream)new FileOutputStream(source));
        }
        catch (IOException e) {
            errorFlag = true;
            log.error("downloadAmrFile and UploadMp3File write error; amrPath:{}", (Object)amrPath, (Object)e);
            e.printStackTrace();
        }
        watch.stop();
        log.info("\u5199\u5165arm\u6587\u4ef6\u8017\u65f6\uff1a{}, fileName:{}", (Object)watch.getLastTaskTimeMillis(), (Object)fileName);
        if (errorFlag.booleanValue()) {
            return resolvedAmrBasicInfoDto;
        }
        watch.start();
        File target = this.convert(this.basePath, source.getAbsolutePath());
        watch.stop();
        log.info("amr\u8f6c\u7801mp3\u6587\u4ef6\u8017\u65f6\uff1a{}, fileName:{}", (Object)watch.getLastTaskTimeMillis(), (Object)fileKey);
        watch.start();
        if (target.exists()) {
            Integer audioDuration = this.getAudioDuration(this.basePath, target.getAbsolutePath());
            watch.stop();
            log.info("\u83b7\u53d6\u8bed\u97f3\u65f6\u957f\u8017\u65f6\uff1a{},fileName:{}", (Object)watch.getLastTaskTimeMillis(), (Object)fileName);
            watch.start();
            try {
                aliYunUrl = AliyunOssUtils.uploadFile(target, fileKey);
            }
            catch (Exception e) {
                log.error("uploadFile amrPath:{}", (Object)amrPath, (Object)e);
                e.printStackTrace();
            }
            resolvedAmrBasicInfoDto.setDuration(audioDuration);
            resolvedAmrBasicInfoDto.setResolvedPath(aliYunUrl);
        }
        watch.stop();
        log.info("\u4e0a\u4f20mp3\u6587\u4ef6\u8017\u65f6\uff1a{},fileName:{}", (Object)watch.getLastTaskTimeMillis(), (Object)fileName);
        FileUtils.deleteQuietly((File)source);
        FileUtils.deleteQuietly((File)target);
        log.info("total convert time:{},fileName:{}", (Object)watch.getTotalTimeMillis(), (Object)fileName);
        return resolvedAmrBasicInfoDto;
    }

    /*
     * Exception decompiling
     */
    private Integer getAudioDuration(String basePath, String audioFullPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getFileKey(String armPath, String fileName) {
        String[] split = armPath.split("/");
        if (split.length > 2) {
            return split[split.length - 2] + File.separator + fileName + FILE_TYPE_MP3_SUFFIX;
        }
        return null;
    }

    private File convert(String basePath, String fileName) {
        log.info("convert basePath:{}, fileName:{}", (Object)basePath, (Object)fileName);
        String[] command = new String[]{basePath + "converter.sh", fileName, "mp3"};
        try {
            Process ps = Runtime.getRuntime().exec(command);
            int exitValue = ps.waitFor();
            if (0 != exitValue) {
                log.error("call shell failed. error code is :" + exitValue);
            }
        }
        catch (Exception e) {
            log.error("convert error fileName:{}", (Object)fileName, (Object)e);
        }
        String mp3LocalPath = FilenameUtils.removeExtension((String)fileName) + FILE_TYPE_MP3_SUFFIX;
        log.info("convert mp3LocalPath:{}", (Object)mp3LocalPath);
        File file = new File(mp3LocalPath);
        return file;
    }
}

