/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.manager.common.dto.wechat;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.enums.WechatMsgType;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.skynet.manager.common.dto.GroupMsgConentDto;
import com.kuaike.skynet.manager.common.dto.wechat.GroupMsgSendConentDto;
import com.kuaike.skynet.manager.common.dto.wechat.MultiSelectSingleWechatInChatRoomListReqDto;
import com.kuaike.skynet.manager.common.dto.wechat.MultiSelectWechatContactListReqDto;
import com.kuaike.skynet.manager.common.dto.wechat.WechatAndChatRoomDto;
import com.kuaike.skynet.manager.common.dto.wechat.WechatAndContactDto;
import com.kuaike.skynet.manager.common.enums.SendType;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AddGroupSendReq
implements Serializable {
    private static final long serialVersionUID = -8756457832105900698L;
    private Long taskId;
    private List<GroupMsgConentDto> content;
    private List<GroupMsgSendConentDto> oldContent;
    private Set<String> groupSendWechatIds;
    private Set<MultiSelectWechatContactListReqDto> groupSendWechatContact;
    private LinkedHashSet<MultiSelectSingleWechatInChatRoomListReqDto> groupSendChatRoom;
    private Integer sendType;
    private Integer engineType;
    private Date sendTime;
    private String taskName;
    private Integer groupSendWechatIdNum;
    private Integer groupSendWechatContactNum;
    private Integer groupSendChatRoomNum;
    private Long fkTaskId;
    private int fkType;
    private Date deadlineTime;
    public static final int max_message_content_length = 20;
    private static final Set<Integer> notNeedMessageType = Sets.newHashSet((Object[])new Integer[]{WechatMsgType.MINI_PROGRAM.getValue(), WechatMsgType.LINK_CARD.getValue(), WechatMsgType.GIF.getValue()});

    public void preValidate(int contentAllowSize) {
        String contentSizeMsg = "\u53d1\u9001\u5185\u5bb9\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc7" + contentAllowSize + "\u4e2a";
        Preconditions.checkArgument((this.content.size() <= contentAllowSize ? 1 : 0) != 0, (Object)contentSizeMsg);
    }

    public void validate(Set<WechatAndContactDto> sendWechatContactSet, Set<WechatAndChatRoomDto> sendChatRoomSet) {
        SendType sendTypeEnum = SendType.getType(this.sendType);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskName), (Object)"\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a");
        Preconditions.checkArgument((this.taskName.length() >= 1 && this.taskName.length() <= 20 ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u540d\u79f01-20\u5b57");
        Preconditions.checkArgument((sendTypeEnum != null ? 1 : 0) != 0, (Object)"\u53d1\u9001\u7c7b\u578b\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.content), (Object)"\u53d1\u9001\u5185\u5bb9\u4fe1\u606f\u4e3a\u7a7a");
        Preconditions.checkArgument((this.content.size() <= 20 ? 1 : 0) != 0, (Object)"\u4e00\u6b21\u7fa4\u53d1\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc720\u6761");
        if (sendTypeEnum.getValue() == SendType.TIMING.getValue()) {
            Preconditions.checkArgument((this.sendTime != null && this.sendTime.after(new Date()) ? 1 : 0) != 0, (Object)"\u5b9a\u65f6\u53d1\u9001,sentTime \u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (this.sendTime == null) {
            this.sendTime = new Date();
        }
        if (this.fkType > 0) {
            Preconditions.checkArgument((this.fkTaskId != null ? 1 : 0) != 0, (Object)"fkTaskId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.content.forEach(t -> t.validate());
        for (GroupMsgConentDto groupMsgConentDto : this.content) {
            if (notNeedMessageType.contains(groupMsgConentDto.getType()) || !StringUtils.isBlank((CharSequence)groupMsgConentDto.getMessage())) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u9001\u5185\u5bb9\u4e3a\u7a7a");
        }
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public List<GroupMsgConentDto> getContent() {
        return this.content;
    }

    public List<GroupMsgSendConentDto> getOldContent() {
        return this.oldContent;
    }

    public Set<String> getGroupSendWechatIds() {
        return this.groupSendWechatIds;
    }

    public Set<MultiSelectWechatContactListReqDto> getGroupSendWechatContact() {
        return this.groupSendWechatContact;
    }

    public LinkedHashSet<MultiSelectSingleWechatInChatRoomListReqDto> getGroupSendChatRoom() {
        return this.groupSendChatRoom;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public Integer getEngineType() {
        return this.engineType;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Integer getGroupSendWechatIdNum() {
        return this.groupSendWechatIdNum;
    }

    public Integer getGroupSendWechatContactNum() {
        return this.groupSendWechatContactNum;
    }

    public Integer getGroupSendChatRoomNum() {
        return this.groupSendChatRoomNum;
    }

    public Long getFkTaskId() {
        return this.fkTaskId;
    }

    public int getFkType() {
        return this.fkType;
    }

    public Date getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setContent(List<GroupMsgConentDto> content) {
        this.content = content;
    }

    public void setOldContent(List<GroupMsgSendConentDto> oldContent) {
        this.oldContent = oldContent;
    }

    public void setGroupSendWechatIds(Set<String> groupSendWechatIds) {
        this.groupSendWechatIds = groupSendWechatIds;
    }

    public void setGroupSendWechatContact(Set<MultiSelectWechatContactListReqDto> groupSendWechatContact) {
        this.groupSendWechatContact = groupSendWechatContact;
    }

    public void setGroupSendChatRoom(LinkedHashSet<MultiSelectSingleWechatInChatRoomListReqDto> groupSendChatRoom) {
        this.groupSendChatRoom = groupSendChatRoom;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public void setEngineType(Integer engineType) {
        this.engineType = engineType;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setGroupSendWechatIdNum(Integer groupSendWechatIdNum) {
        this.groupSendWechatIdNum = groupSendWechatIdNum;
    }

    public void setGroupSendWechatContactNum(Integer groupSendWechatContactNum) {
        this.groupSendWechatContactNum = groupSendWechatContactNum;
    }

    public void setGroupSendChatRoomNum(Integer groupSendChatRoomNum) {
        this.groupSendChatRoomNum = groupSendChatRoomNum;
    }

    public void setFkTaskId(Long fkTaskId) {
        this.fkTaskId = fkTaskId;
    }

    public void setFkType(int fkType) {
        this.fkType = fkType;
    }

    public void setDeadlineTime(Date deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddGroupSendReq)) {
            return false;
        }
        AddGroupSendReq other = (AddGroupSendReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        List<GroupMsgConentDto> this$content = this.getContent();
        List<GroupMsgConentDto> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        List<GroupMsgSendConentDto> this$oldContent = this.getOldContent();
        List<GroupMsgSendConentDto> other$oldContent = other.getOldContent();
        if (this$oldContent == null ? other$oldContent != null : !((Object)this$oldContent).equals(other$oldContent)) {
            return false;
        }
        Set<String> this$groupSendWechatIds = this.getGroupSendWechatIds();
        Set<String> other$groupSendWechatIds = other.getGroupSendWechatIds();
        if (this$groupSendWechatIds == null ? other$groupSendWechatIds != null : !((Object)this$groupSendWechatIds).equals(other$groupSendWechatIds)) {
            return false;
        }
        Set<MultiSelectWechatContactListReqDto> this$groupSendWechatContact = this.getGroupSendWechatContact();
        Set<MultiSelectWechatContactListReqDto> other$groupSendWechatContact = other.getGroupSendWechatContact();
        if (this$groupSendWechatContact == null ? other$groupSendWechatContact != null : !((Object)this$groupSendWechatContact).equals(other$groupSendWechatContact)) {
            return false;
        }
        LinkedHashSet<MultiSelectSingleWechatInChatRoomListReqDto> this$groupSendChatRoom = this.getGroupSendChatRoom();
        LinkedHashSet<MultiSelectSingleWechatInChatRoomListReqDto> other$groupSendChatRoom = other.getGroupSendChatRoom();
        if (this$groupSendChatRoom == null ? other$groupSendChatRoom != null : !((Object)this$groupSendChatRoom).equals(other$groupSendChatRoom)) {
            return false;
        }
        Integer this$sendType = this.getSendType();
        Integer other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !((Object)this$sendType).equals(other$sendType)) {
            return false;
        }
        Integer this$engineType = this.getEngineType();
        Integer other$engineType = other.getEngineType();
        if (this$engineType == null ? other$engineType != null : !((Object)this$engineType).equals(other$engineType)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        Integer this$groupSendWechatIdNum = this.getGroupSendWechatIdNum();
        Integer other$groupSendWechatIdNum = other.getGroupSendWechatIdNum();
        if (this$groupSendWechatIdNum == null ? other$groupSendWechatIdNum != null : !((Object)this$groupSendWechatIdNum).equals(other$groupSendWechatIdNum)) {
            return false;
        }
        Integer this$groupSendWechatContactNum = this.getGroupSendWechatContactNum();
        Integer other$groupSendWechatContactNum = other.getGroupSendWechatContactNum();
        if (this$groupSendWechatContactNum == null ? other$groupSendWechatContactNum != null : !((Object)this$groupSendWechatContactNum).equals(other$groupSendWechatContactNum)) {
            return false;
        }
        Integer this$groupSendChatRoomNum = this.getGroupSendChatRoomNum();
        Integer other$groupSendChatRoomNum = other.getGroupSendChatRoomNum();
        if (this$groupSendChatRoomNum == null ? other$groupSendChatRoomNum != null : !((Object)this$groupSendChatRoomNum).equals(other$groupSendChatRoomNum)) {
            return false;
        }
        Long this$fkTaskId = this.getFkTaskId();
        Long other$fkTaskId = other.getFkTaskId();
        if (this$fkTaskId == null ? other$fkTaskId != null : !((Object)this$fkTaskId).equals(other$fkTaskId)) {
            return false;
        }
        if (this.getFkType() != other.getFkType()) {
            return false;
        }
        Date this$deadlineTime = this.getDeadlineTime();
        Date other$deadlineTime = other.getDeadlineTime();
        return !(this$deadlineTime == null ? other$deadlineTime != null : !((Object)this$deadlineTime).equals(other$deadlineTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddGroupSendReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        List<GroupMsgConentDto> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        List<GroupMsgSendConentDto> $oldContent = this.getOldContent();
        result = result * 59 + ($oldContent == null ? 43 : ((Object)$oldContent).hashCode());
        Set<String> $groupSendWechatIds = this.getGroupSendWechatIds();
        result = result * 59 + ($groupSendWechatIds == null ? 43 : ((Object)$groupSendWechatIds).hashCode());
        Set<MultiSelectWechatContactListReqDto> $groupSendWechatContact = this.getGroupSendWechatContact();
        result = result * 59 + ($groupSendWechatContact == null ? 43 : ((Object)$groupSendWechatContact).hashCode());
        LinkedHashSet<MultiSelectSingleWechatInChatRoomListReqDto> $groupSendChatRoom = this.getGroupSendChatRoom();
        result = result * 59 + ($groupSendChatRoom == null ? 43 : ((Object)$groupSendChatRoom).hashCode());
        Integer $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 43 : ((Object)$sendType).hashCode());
        Integer $engineType = this.getEngineType();
        result = result * 59 + ($engineType == null ? 43 : ((Object)$engineType).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        Integer $groupSendWechatIdNum = this.getGroupSendWechatIdNum();
        result = result * 59 + ($groupSendWechatIdNum == null ? 43 : ((Object)$groupSendWechatIdNum).hashCode());
        Integer $groupSendWechatContactNum = this.getGroupSendWechatContactNum();
        result = result * 59 + ($groupSendWechatContactNum == null ? 43 : ((Object)$groupSendWechatContactNum).hashCode());
        Integer $groupSendChatRoomNum = this.getGroupSendChatRoomNum();
        result = result * 59 + ($groupSendChatRoomNum == null ? 43 : ((Object)$groupSendChatRoomNum).hashCode());
        Long $fkTaskId = this.getFkTaskId();
        result = result * 59 + ($fkTaskId == null ? 43 : ((Object)$fkTaskId).hashCode());
        result = result * 59 + this.getFkType();
        Date $deadlineTime = this.getDeadlineTime();
        result = result * 59 + ($deadlineTime == null ? 43 : ((Object)$deadlineTime).hashCode());
        return result;
    }

    public String toString() {
        return "AddGroupSendReq(taskId=" + this.getTaskId() + ", content=" + this.getContent() + ", oldContent=" + this.getOldContent() + ", groupSendWechatIds=" + this.getGroupSendWechatIds() + ", groupSendWechatContact=" + this.getGroupSendWechatContact() + ", groupSendChatRoom=" + this.getGroupSendChatRoom() + ", sendType=" + this.getSendType() + ", engineType=" + this.getEngineType() + ", sendTime=" + this.getSendTime() + ", taskName=" + this.getTaskName() + ", groupSendWechatIdNum=" + this.getGroupSendWechatIdNum() + ", groupSendWechatContactNum=" + this.getGroupSendWechatContactNum() + ", groupSendChatRoomNum=" + this.getGroupSendChatRoomNum() + ", fkTaskId=" + this.getFkTaskId() + ", fkType=" + this.getFkType() + ", deadlineTime=" + this.getDeadlineTime() + ")";
    }
}

