/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.manager.common.dto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.enums.WechatMsgType;
import com.kuaike.skynet.manager.common.dto.LinkCardMessage;
import com.kuaike.skynet.manager.common.dto.ReplyJoinGroupCardDto;
import com.kuaike.skynet.manager.common.dto.message.MiniProgramMessage;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GroupMsgConentDto
implements Serializable {
    private static final long serialVersionUID = -2302529130475154897L;
    private static Set<Integer> SUPPORT_TYPE = Sets.newHashSet((Object[])new Integer[]{WechatMsgType.TEXT.getValue(), WechatMsgType.IMAGE.getValue(), WechatMsgType.VOICE.getValue(), WechatMsgType.VIDEO.getValue(), WechatMsgType.FILE.getValue(), WechatMsgType.LINK_CARD.getValue(), WechatMsgType.MINI_PROGRAM.getValue(), WechatMsgType.JOIN_GROUP_CARD.getValue()});
    private Long drainageId;
    private Long fissionId;
    private Long officialActiId;
    private Integer type;
    private String message;
    private String title;
    private Integer duration;
    private Long officialNewsId;
    private String linkUrl;
    private String iconUrl;
    private String planTitle;
    private MiniProgramMessage miniProgramMessage;
    private ReplyJoinGroupCardDto groupCardMessage;

    public void validate() {
        if (Objects.nonNull(this.type)) {
            Preconditions.checkArgument((boolean)SUPPORT_TYPE.contains(this.type), (Object)("\u4e0d\u652f\u6301\u6d88\u606f\u7c7b\u578b\uff0ctype:" + this.type));
            if (WechatMsgType.TEXT.getValue() == this.type.intValue()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.message), (Object)"\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (WechatMsgType.IMAGE.getValue() == this.type.intValue() || WechatMsgType.VOICE.getValue() == this.type.intValue() || WechatMsgType.VIDEO.getValue() == this.type.intValue()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.message), (Object)"\u6587\u4ef6url\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (WechatMsgType.LINK_CARD.getValue() == this.type.intValue()) {
                boolean allNotExists = this.existsCommonLink() == false && Objects.isNull(this.officialNewsId);
                Preconditions.checkArgument((!allNotExists ? 1 : 0) != 0, (Object)"\u56fe\u6587\u6216\u8005\u94fe\u63a5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                boolean allExists = this.existsCommonLink() != false && Objects.nonNull(this.officialNewsId);
                Preconditions.checkArgument((!allExists ? 1 : 0) != 0, (Object)"\u56fe\u6587\u6216\u8005\u94fe\u63a5\u4e0d\u80fd\u540c\u65f6\u5b58\u5728");
                if (Objects.isNull(this.officialNewsId)) {
                    new LinkCardMessage(this.title, this.message, this.linkUrl, this.iconUrl).validate();
                }
            } else if (WechatMsgType.MINI_PROGRAM.getValue() == this.type.intValue()) {
                Preconditions.checkArgument((boolean)Objects.nonNull(this.miniProgramMessage), (Object)"\u5c0f\u7a0b\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
                this.miniProgramMessage.validate();
            } else if (WechatMsgType.JOIN_GROUP_CARD.getValue() == this.type.intValue()) {
                Preconditions.checkArgument((boolean)Objects.nonNull(this.groupCardMessage), (Object)"groupCardMessage is null");
                this.groupCardMessage.validate();
            }
        } else {
            Preconditions.checkArgument((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{this.drainageId, this.fissionId, this.officialActiId}), (Object)"\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5");
        }
    }

    private Boolean existsCommonLink() {
        return StringUtils.isNotBlank((CharSequence)this.title) && StringUtils.isNotBlank((CharSequence)this.linkUrl);
    }

    public Long getDrainageId() {
        return this.drainageId;
    }

    public Long getFissionId() {
        return this.fissionId;
    }

    public Long getOfficialActiId() {
        return this.officialActiId;
    }

    public Integer getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Long getOfficialNewsId() {
        return this.officialNewsId;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getPlanTitle() {
        return this.planTitle;
    }

    public MiniProgramMessage getMiniProgramMessage() {
        return this.miniProgramMessage;
    }

    public ReplyJoinGroupCardDto getGroupCardMessage() {
        return this.groupCardMessage;
    }

    public void setDrainageId(Long drainageId) {
        this.drainageId = drainageId;
    }

    public void setFissionId(Long fissionId) {
        this.fissionId = fissionId;
    }

    public void setOfficialActiId(Long officialActiId) {
        this.officialActiId = officialActiId;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setOfficialNewsId(Long officialNewsId) {
        this.officialNewsId = officialNewsId;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setPlanTitle(String planTitle) {
        this.planTitle = planTitle;
    }

    public void setMiniProgramMessage(MiniProgramMessage miniProgramMessage) {
        this.miniProgramMessage = miniProgramMessage;
    }

    public void setGroupCardMessage(ReplyJoinGroupCardDto groupCardMessage) {
        this.groupCardMessage = groupCardMessage;
    }

    public String toString() {
        return "GroupMsgConentDto(drainageId=" + this.getDrainageId() + ", fissionId=" + this.getFissionId() + ", officialActiId=" + this.getOfficialActiId() + ", type=" + this.getType() + ", message=" + this.getMessage() + ", title=" + this.getTitle() + ", duration=" + this.getDuration() + ", officialNewsId=" + this.getOfficialNewsId() + ", linkUrl=" + this.getLinkUrl() + ", iconUrl=" + this.getIconUrl() + ", planTitle=" + this.getPlanTitle() + ", miniProgramMessage=" + this.getMiniProgramMessage() + ", groupCardMessage=" + this.getGroupCardMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupMsgConentDto)) {
            return false;
        }
        GroupMsgConentDto other = (GroupMsgConentDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$drainageId = this.getDrainageId();
        Long other$drainageId = other.getDrainageId();
        if (this$drainageId == null ? other$drainageId != null : !((Object)this$drainageId).equals(other$drainageId)) {
            return false;
        }
        Long this$fissionId = this.getFissionId();
        Long other$fissionId = other.getFissionId();
        if (this$fissionId == null ? other$fissionId != null : !((Object)this$fissionId).equals(other$fissionId)) {
            return false;
        }
        Long this$officialActiId = this.getOfficialActiId();
        Long other$officialActiId = other.getOfficialActiId();
        if (this$officialActiId == null ? other$officialActiId != null : !((Object)this$officialActiId).equals(other$officialActiId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Long this$officialNewsId = this.getOfficialNewsId();
        Long other$officialNewsId = other.getOfficialNewsId();
        if (this$officialNewsId == null ? other$officialNewsId != null : !((Object)this$officialNewsId).equals(other$officialNewsId)) {
            return false;
        }
        String this$linkUrl = this.getLinkUrl();
        String other$linkUrl = other.getLinkUrl();
        if (this$linkUrl == null ? other$linkUrl != null : !this$linkUrl.equals(other$linkUrl)) {
            return false;
        }
        String this$iconUrl = this.getIconUrl();
        String other$iconUrl = other.getIconUrl();
        if (this$iconUrl == null ? other$iconUrl != null : !this$iconUrl.equals(other$iconUrl)) {
            return false;
        }
        String this$planTitle = this.getPlanTitle();
        String other$planTitle = other.getPlanTitle();
        if (this$planTitle == null ? other$planTitle != null : !this$planTitle.equals(other$planTitle)) {
            return false;
        }
        MiniProgramMessage this$miniProgramMessage = this.getMiniProgramMessage();
        MiniProgramMessage other$miniProgramMessage = other.getMiniProgramMessage();
        if (this$miniProgramMessage == null ? other$miniProgramMessage != null : !((Object)this$miniProgramMessage).equals(other$miniProgramMessage)) {
            return false;
        }
        ReplyJoinGroupCardDto this$groupCardMessage = this.getGroupCardMessage();
        ReplyJoinGroupCardDto other$groupCardMessage = other.getGroupCardMessage();
        return !(this$groupCardMessage == null ? other$groupCardMessage != null : !((Object)this$groupCardMessage).equals(other$groupCardMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupMsgConentDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $drainageId = this.getDrainageId();
        result = result * 59 + ($drainageId == null ? 43 : ((Object)$drainageId).hashCode());
        Long $fissionId = this.getFissionId();
        result = result * 59 + ($fissionId == null ? 43 : ((Object)$fissionId).hashCode());
        Long $officialActiId = this.getOfficialActiId();
        result = result * 59 + ($officialActiId == null ? 43 : ((Object)$officialActiId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Long $officialNewsId = this.getOfficialNewsId();
        result = result * 59 + ($officialNewsId == null ? 43 : ((Object)$officialNewsId).hashCode());
        String $linkUrl = this.getLinkUrl();
        result = result * 59 + ($linkUrl == null ? 43 : $linkUrl.hashCode());
        String $iconUrl = this.getIconUrl();
        result = result * 59 + ($iconUrl == null ? 43 : $iconUrl.hashCode());
        String $planTitle = this.getPlanTitle();
        result = result * 59 + ($planTitle == null ? 43 : $planTitle.hashCode());
        MiniProgramMessage $miniProgramMessage = this.getMiniProgramMessage();
        result = result * 59 + ($miniProgramMessage == null ? 43 : ((Object)$miniProgramMessage).hashCode());
        ReplyJoinGroupCardDto $groupCardMessage = this.getGroupCardMessage();
        result = result * 59 + ($groupCardMessage == null ? 43 : ((Object)$groupCardMessage).hashCode());
        return result;
    }
}

