/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.manager.common.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.enums.WechatMsgType;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GroupAssistantMsgContentDto
implements Serializable {
    private static final long serialVersionUID = 4500909559648264390L;
    private static Set<Integer> SUPPORT_TYPE = Sets.newHashSet((Object[])new Integer[]{WechatMsgType.TEXT.getValue(), WechatMsgType.IMAGE.getValue(), WechatMsgType.VOICE.getValue(), WechatMsgType.VIDEO.getValue()});
    private Long drainageId;
    private Long fissionId;
    private Integer type;
    private String message;
    private String title;
    private Integer duration;
    private String planTitle;

    public void validate() {
        if (Objects.nonNull(this.type)) {
            Preconditions.checkArgument((boolean)SUPPORT_TYPE.contains(this.type), (Object)("\u4e0d\u652f\u6301\u6d88\u606f\u7c7b\u578b\uff0ctype:" + this.type));
            if (WechatMsgType.TEXT.getValue() == this.type.intValue()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.message), (Object)"\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (WechatMsgType.IMAGE.getValue() == this.type.intValue() || WechatMsgType.VOICE.getValue() == this.type.intValue() || WechatMsgType.VIDEO.getValue() == this.type.intValue()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.message), (Object)"\u6587\u4ef6url\u4e0d\u80fd\u4e3a\u7a7a");
                if (WechatMsgType.VOICE.getValue() == this.type.intValue()) {
                    Preconditions.checkArgument((boolean)Objects.nonNull(this.duration), (Object)"\u8bed\u97f3\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        } else {
            Preconditions.checkArgument((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{this.drainageId, this.fissionId}), (Object)"\u6f0f\u6597\u6216\u88c2\u53d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public Long getDrainageId() {
        return this.drainageId;
    }

    public Long getFissionId() {
        return this.fissionId;
    }

    public Integer getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getPlanTitle() {
        return this.planTitle;
    }

    public void setDrainageId(Long drainageId) {
        this.drainageId = drainageId;
    }

    public void setFissionId(Long fissionId) {
        this.fissionId = fissionId;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setPlanTitle(String planTitle) {
        this.planTitle = planTitle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupAssistantMsgContentDto)) {
            return false;
        }
        GroupAssistantMsgContentDto other = (GroupAssistantMsgContentDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$drainageId = this.getDrainageId();
        Long other$drainageId = other.getDrainageId();
        if (this$drainageId == null ? other$drainageId != null : !((Object)this$drainageId).equals(other$drainageId)) {
            return false;
        }
        Long this$fissionId = this.getFissionId();
        Long other$fissionId = other.getFissionId();
        if (this$fissionId == null ? other$fissionId != null : !((Object)this$fissionId).equals(other$fissionId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$planTitle = this.getPlanTitle();
        String other$planTitle = other.getPlanTitle();
        return !(this$planTitle == null ? other$planTitle != null : !this$planTitle.equals(other$planTitle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupAssistantMsgContentDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $drainageId = this.getDrainageId();
        result = result * 59 + ($drainageId == null ? 43 : ((Object)$drainageId).hashCode());
        Long $fissionId = this.getFissionId();
        result = result * 59 + ($fissionId == null ? 43 : ((Object)$fissionId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $planTitle = this.getPlanTitle();
        result = result * 59 + ($planTitle == null ? 43 : $planTitle.hashCode());
        return result;
    }

    public String toString() {
        return "GroupAssistantMsgContentDto(drainageId=" + this.getDrainageId() + ", fissionId=" + this.getFissionId() + ", type=" + this.getType() + ", message=" + this.getMessage() + ", title=" + this.getTitle() + ", duration=" + this.getDuration() + ", planTitle=" + this.getPlanTitle() + ")";
    }
}

