/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common.utils;

import com.kuaike.skynet.logic.service.common.utils.NamedThreadFactory;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolMonitorUtils
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolMonitorUtils.class);
    @Autowired
    private HikariDataSource hikariDataSource;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, new NamedThreadFactory("ThreadPoolMoniter"));
    private static CopyOnWriteArrayList<ThreadPoolExecutor> toPrintThreadPools = new CopyOnWriteArrayList();
    private AtomicBoolean isRunning = new AtomicBoolean(false);

    public void start() {
        log.info("Start monitor.");
        Runnable printTask = () -> {
            for (ThreadPoolExecutor executorService : toPrintThreadPools) {
                this.printThreadPoolStatus(executorService);
            }
            this.dataSourcePoolMonitor();
        };
        this.executorService.scheduleWithFixedDelay(printTask, 30L, 60L, TimeUnit.SECONDS);
    }

    private void dataSourcePoolMonitor() {
        HikariPoolMXBean hikariPoolMXBean = this.hikariDataSource.getHikariPoolMXBean();
        if (hikariPoolMXBean == null) {
            return;
        }
        int activeConnections = hikariPoolMXBean.getActiveConnections();
        int idleConnections = hikariPoolMXBean.getIdleConnections();
        int totalConnections = hikariPoolMXBean.getTotalConnections();
        int threadsAwaitingConnection = hikariPoolMXBean.getThreadsAwaitingConnection();
        log.info("hikariPool: activeConnections:{}, idleConnections:{}, threadsAwaitingConnection:{}, totalConnections:{}", new Object[]{activeConnections, idleConnections, threadsAwaitingConnection, totalConnections});
    }

    private void printThreadPoolStatus(ThreadPoolExecutor tpe) {
        String threadFactoryNamePrefix = "";
        ThreadFactory threadFactory = tpe.getThreadFactory();
        if (threadFactory instanceof NamedThreadFactory) {
            NamedThreadFactory namedThreadFactory = (NamedThreadFactory)threadFactory;
            threadFactoryNamePrefix = namedThreadFactory.getNamePrefix();
        }
        log.info("\u7ebf\u7a0b\u6c60: {} {}", (Object)threadFactoryNamePrefix, (Object)tpe.toString());
    }

    public static void addToMonitor(ExecutorService executorService) {
        try {
            if (executorService instanceof ThreadPoolExecutor) {
                toPrintThreadPools.add((ThreadPoolExecutor)executorService);
            }
        }
        catch (Exception e) {
            log.error("addToMonter error", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdown();
        toPrintThreadPools.clear();
        log.info("monitor destroy success");
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (this.isRunning.compareAndSet(false, true)) {
            this.start();
        }
    }
}

