/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;

public class JacksonUtils {
    private static JacksonUtils instance = new JacksonUtils();
    private ObjectMapper objectMapper = new ObjectMapper();
    private XmlMapper xmlMapper;

    public static JacksonUtils getInstance() {
        return instance;
    }

    public JacksonUtils() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.xmlMapper = new XmlMapper();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public XmlMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return this.getObjectMapper().writeValueAsString(value);
    }

    public <T> T readValue(String content, Class<T> valueType) throws IOException {
        return (T)this.objectMapper.readValue(content, valueType);
    }
}

