package com.kuaike.skynet.manager.wechat.service;

import java.util.List;
import java.util.Map;

/**
 * 备用群相关操作，对外提供dubbo服务
 */
public interface WechatChatRoomPoolService {

    /**
     * 查询机器人剩余有效备用群数(七天内有更新上报的备用群)
     * @param businessCustomerId 商户id(必填)
     * @param wechatIds 查询的微信ids(非必填)
     * @return
     */
    Map<String, Integer> queryChatRoomPoolCapacity(Long businessCustomerId, List<String> wechatIds);

    /**
     * 使用备用群
     * @param wechatId 群主微信id(必填)
     * @return
     */
    String usePoolChatRoom(String wechatId);

}
