package com.kuaike.skynet.manager.wechat.dto;

import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * @description: 修改群名事件
 * @author: liuguohong
 * @create: 2020/07/21 17:11
 */
@Data
public class ModGroupNameRecord extends GroupEventRecord {
    private String chatRoomName;// 新的群名称
    private String updateBy;    // 操作wechatId
    private Date modTime;       // 修改时间
    private String requestId;

    private String updateByWechatNickName;        // 操作微信昵称

    public static boolean isValidate(ModGroupNameRecord modGroupNameRecord) {
        if (Objects.isNull(modGroupNameRecord)) {
            return false;
        }
        if (Objects.isNull(modGroupNameRecord.getChatRoomId()) ||
                Objects.isNull(modGroupNameRecord.getModTime()) ||
                Objects.isNull(modGroupNameRecord.getUpdateBy()) ||
                Objects.isNull(modGroupNameRecord.getChatRoomName())) {
            return false;
        }
        return true;
    }

}
