package com.kuaike.skynet.manager.wechat.dto;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/05/27 22:15
 */
@Data
public class JoinGroupRecord extends GroupEventRecord {
    private String inviteWechatId;
    private List<String> memberIds;
    private Integer type;
    private Integer subType;
    private Date joinGroupTime;
    private String requestId;
    private Long customerId;

    public static boolean isValidate(JoinGroupRecord joinGroupRecord) {
        if (Objects.isNull(joinGroupRecord)) {
            return false;
        }
        if (Objects.isNull(joinGroupRecord.getChatRoomId()) ||
                Objects.isNull(joinGroupRecord.getInviteWechatId()) ||
                CollectionUtils.isEmpty(joinGroupRecord.getMemberIds())) {
            return false;
        }
        return true;
    }
}
