package com.kuaike.skynet.manager.wechat.dto;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/05/28 23:18
 */

@Data
public class ExitGroupRecord extends GroupEventRecord {
    private String exitBy;
    private List<String> memberIds;
    private Integer type;
    private Date exitGroupTime;
    private String exitBeforeMembersMd5;

    public static boolean isValidate(ExitGroupRecord exitGroupRecord) {
        return exitGroupRecord != null &&
                exitGroupRecord.getWechatId() != null
                && exitGroupRecord.getChatRoomId() != null
                && !CollectionUtils.isEmpty(exitGroupRecord.getMemberIds());
    }
}
