package com.kuaike.skynet.manager.wechat.dto;

import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * @description: 转让群主
 * @author: liuguohong
 * @create: 2020/07/22 09:54
 */
@Data
public class ChangeGroupOwnerRecord extends GroupEventRecord {
    private String newOwner;
    private Date modTime;
    private String requestId;

    public static boolean isValidate(ChangeGroupOwnerRecord changeGroupOwnerRecord) {
        if (Objects.isNull(changeGroupOwnerRecord)) {
            return false;
        }
        if (Objects.isNull(changeGroupOwnerRecord.getChatRoomId()) ||
                Objects.isNull(changeGroupOwnerRecord.getModTime()) ||
                Objects.isNull(changeGroupOwnerRecord.getNewOwner())) {
            return false;
        }
        return true;
    }
}
